/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.redo;

import com.google.gson.JsonElement;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.sc.ContractResult;
import org.bdware.sc.bean.ContractRequest;
import org.bdware.sc.engine.DesktopEngine;
import org.bdware.sc.redo.TransRecord;
import org.bdware.sc.util.JsonUtil;

public class TransRecoverUtil {
    private static final Logger LOGGER = LogManager.getLogger(TransRecoverUtil.class);
    public ArrayList<TransRecord> transRecords;
    public TransRecord curRecoverRecord;
    DesktopEngine engine;

    public TransRecoverUtil(DesktopEngine en) {
        this.engine = en;
        this.transRecords = new ArrayList();
    }

    public void setTraceRecords(String fileName) {
        TransRecord cur_read = null;
        File file = new File(fileName);
        try {
            FileReader fr = new FileReader(file);
            BufferedReader br = new BufferedReader(fr);
            String line = "";
            Object arrs = null;
            while ((line = br.readLine()) != null) {
                String[] strs = line.split(";");
                String arg = strs.length < 5 ? null : strs[4];
                if (strs[0].equals("===TransRecord===")) {
                    if (cur_read != null) {
                        this.transRecords.add(cur_read);
                        System.out.println("\u6062\u590d\u65f6\u52a0\u5165 " + cur_read.toString());
                    }
                    if (strs[1].equals("true")) {
                        cur_read = new TransRecord(strs[3], JsonUtil.parseString((String)arg), Integer.parseInt(strs[2]));
                        continue;
                    }
                    cur_read = new TransRecord(strs[3], JsonUtil.parseString((String)arg));
                    continue;
                }
                cur_read.addExecutes(strs[0], strs[1]);
            }
            if (cur_read != null) {
                this.transRecords.add(cur_read);
                System.out.println("\u6062\u590d\u65f6\u52a0\u5165 " + cur_read.toString());
            }
            br.close();
            fr.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recoverFromTransRecord() {
        DesktopEngine desktopEngine = this.engine;
        synchronized (desktopEngine) {
            this.engine.setRecovering(true);
            for (int i = 0; i < this.transRecords.size(); ++i) {
                this.curRecoverRecord = this.transRecords.get(i);
                String funName = this.curRecoverRecord.getFuncName();
                JsonElement arg = this.curRecoverRecord.getArg();
                ContractRequest ac = null;
                ac = new ContractRequest();
                ac.setAction(funName);
                ac.setArg(arg);
                ac.needSeq = this.curRecoverRecord.needSeq;
                if (ac.needSeq.booleanValue()) {
                    ac.seq = this.curRecoverRecord.seq;
                    LOGGER.info("[TransRecordUtil]  redo \u91cd\u65b0\u6267\u884c\u4e8b\u52a1 " + ac.seq);
                }
                System.out.println("[TransRecoverUtil] recover " + ac.needSeq + " " + ac.seq + "  " + ac.getAction() + " " + ac.getArg());
                ContractResult result = this.engine.executeContract(ac);
                if (result.status == ContractResult.Status.Success) continue;
                System.out.println("[\u9519\u8bef]" + result.status);
            }
            this.engine.setRecovering(false);
        }
    }

    public void recoverFromATransRecord(TransRecord record) {
    }
}

