/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.crdt.planning;

import org.bdware.sc.crdt.planning.SharableNetworkPlanning;

public class PlanningWith1Expansivity
extends SharableNetworkPlanning {
    public PlanningWith1Expansivity(String[] nodeIds, int[] writers, int[] readers, long maxDelay, int bandwidthDownload, int bandwidthUpload, int dataSize) {
        this.nodeIds = nodeIds;
        this.writers = writers;
        this.readers = readers;
        this.maxDelay = maxDelay;
        this.bandwidthDownload = bandwidthDownload;
        this.bandwidthUpload = bandwidthUpload;
        this.dataSize = dataSize;
        this.totalCountW = writers.length;
        this.totalCountR = readers.length;
    }

    @Override
    public boolean writerTreeConstraint() {
        if (this.frequencySyncW > 0.0) {
            double common = this.frequencySyncW * (this.treeNodeCountW - 1.0) * (double)this.dataSize;
            boolean result1 = (double)this.bandwidthDownload >= common;
            boolean result2 = (double)this.bandwidthUpload >= common / this.treeDegreeW;
            return result1 && result2;
        }
        return true;
    }

    @Override
    public boolean writer2ReaderConstraint() {
        double common = this.frequencySyncWR * this.totalCountW * (double)this.dataSize;
        boolean result1 = (double)this.bandwidthUpload >= common * this.rootCountR / this.rootCountW;
        boolean result2 = (double)this.bandwidthDownload >= common;
        return result1 && result2;
    }

    @Override
    public boolean readerTreeConstraint() {
        if (this.frequencySyncR > 0.0) {
            double common = this.frequencySyncR * this.totalCountW * (double)this.dataSize;
            boolean result1 = (double)this.bandwidthUpload >= common * this.treeDegreeR;
            boolean result2 = (double)this.bandwidthDownload >= common;
            return result1 && result2;
        }
        return true;
    }

    @Override
    public void calcOptimizedResult() {
        double a = 0.0;
        if (this.treeHeightW > 1.0) {
            a = this.treeDegreeW > 1.0 ? (this.treeHeightW - 1.0) * (this.treeHeightW * Math.pow(this.treeDegreeW, this.treeHeightW) / (this.treeDegreeW - 1.0) + (this.treeDegreeW - Math.pow(this.treeDegreeW, this.treeHeightW + 1.0)) / (this.treeDegreeW - 1.0) / (this.treeDegreeW - 1.0)) * this.rootCountW : (this.treeHeightW - 1.0) * (this.treeHeightW - 1.0) * this.treeHeightW / 2.0;
        }
        double b = this.rootCountR * this.totalCountW;
        double c = (this.totalCountR - this.rootCountR) * (this.treeHeightR - 1.0) * this.totalCountW;
        double A = Math.sqrt(a);
        double B = Math.sqrt(b);
        double C = Math.sqrt(c);
        this.wDelay = (long)Math.ceil((double)this.maxDelay * (A / (A + B + C)));
        this.w2rDelay = (long)Math.ceil((double)this.maxDelay * (B / (A + B + C)));
        this.rDelay = (long)Math.ceil((double)this.maxDelay * (C / (A + B + C)));
        this.frequencySyncW = this.wDelay > 0L ? (this.treeHeightW - 1.0) / (double)this.wDelay : 0.0;
        this.frequencySyncR = this.rDelay > 0L ? (this.treeHeightR - 1.0) / (double)this.rDelay : 0.0;
        this.frequencySyncWR = this.w2rDelay > 0L ? 1.0 / (double)this.w2rDelay : 0.0;
        this.totalData = (long)((double)this.dataSize * (this.frequencySyncW * a + this.frequencySyncWR * b + this.frequencySyncR * c));
    }
}

