/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.crdt.planning;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class SharableNetworkPlanning {
    protected String[] nodeIds;
    protected int[] writers;
    protected int[] readers;
    protected long maxDelay;
    protected int bandwidthDownload;
    protected int bandwidthUpload;
    protected int dataSize;
    protected long wDelay;
    protected long rDelay;
    protected long w2rDelay;
    protected double totalCountW;
    protected double rootCountW;
    protected double treeNodeCountW;
    protected double treeDegreeW;
    protected double treeHeightW;
    protected double frequencySyncW;
    protected double totalCountR;
    protected double rootCountR;
    protected double treeNodeCountR;
    protected double treeDegreeR;
    protected double treeHeightR;
    protected double frequencySyncR;
    protected double frequencySyncWR;
    protected long totalData;

    protected static double logNM(double n, double m) {
        return Math.log(m) / Math.log(n);
    }

    public void adjustWriterTree(int rootCountW, int treeDegreeW) {
        this.rootCountW = rootCountW;
        this.treeDegreeW = treeDegreeW;
        this.treeNodeCountW = Math.ceil(this.totalCountW / (double)rootCountW);
        this.treeHeightW = treeDegreeW > 1 ? Math.ceil(SharableNetworkPlanning.logNM(treeDegreeW, this.treeNodeCountW * (double)(treeDegreeW - 1) + 1.0)) : this.treeNodeCountW;
    }

    public void adjustReaderTree(int rootCountR, int treeDegreeR) {
        this.rootCountR = rootCountR;
        this.treeDegreeR = treeDegreeR;
        this.treeNodeCountR = Math.ceil(this.totalCountR / (double)rootCountR);
        this.treeHeightR = treeDegreeR > 1 ? Math.ceil(SharableNetworkPlanning.logNM(treeDegreeR, this.treeNodeCountR * (double)(treeDegreeR - 1) + 1.0)) : this.treeNodeCountR;
    }

    protected void adjustAndCalc() {
        long minTotalData = Long.MAX_VALUE;
        String result = "";
        for (int rootCountW = 1; rootCountW <= this.writers.length; ++rootCountW) {
            int nodeCountPerTree = (int)Math.ceil((double)this.writers.length * 1.0 / (double)rootCountW);
            for (int treeDegreeW = 1; treeDegreeW <= nodeCountPerTree; ++treeDegreeW) {
                this.adjustWriterTree(rootCountW, treeDegreeW);
                for (int rootCountR = 1; rootCountR <= this.readers.length; ++rootCountR) {
                    int maxTreeDegreeR = (int)Math.ceil((double)this.readers.length * 1.0 / (double)rootCountR);
                    for (int treeDegreeR = 1; treeDegreeR <= maxTreeDegreeR; ++treeDegreeR) {
                        this.adjustReaderTree(rootCountR, treeDegreeR);
                        this.calcOptimizedResult();
                        if (!this.readerTreeConstraint() || !this.writerTreeConstraint() || !this.writer2ReaderConstraint() || this.totalData <= 0L || minTotalData <= this.totalData) continue;
                        minTotalData = this.totalData;
                        result = this.toString();
                    }
                }
            }
        }
        System.out.println(minTotalData);
        System.out.println(result);
    }

    protected void calcOptimizedResult() {
    }

    protected boolean writer2ReaderConstraint() {
        return true;
    }

    protected boolean writerTreeConstraint() {
        return true;
    }

    protected boolean readerTreeConstraint() {
        return true;
    }

    public void allocate() {
        LinkedHashSet<Integer> writerOnlySet = new LinkedHashSet<Integer>();
        for (int i : this.writers) {
            writerOnlySet.add(i);
        }
        LinkedHashSet<Integer> readerOnlySet = new LinkedHashSet<Integer>();
        LinkedHashSet<Integer> rwSet = new LinkedHashSet<Integer>();
        for (int i : this.readers) {
            if (writerOnlySet.contains(i)) {
                rwSet.add(i);
                writerOnlySet.remove(i);
                continue;
            }
            readerOnlySet.add(i);
        }
        int[] writerParents = this.allocateTreeNode(writerOnlySet, rwSet, (int)this.rootCountW, (int)this.treeDegreeW, this.wDelay, (int)this.treeHeightW);
        int[] readerParents = this.allocateTreeNode(readerOnlySet, rwSet, (int)this.rootCountR, (int)this.treeDegreeR, this.rDelay, (int)this.treeHeightR);
        System.out.println(readerParents);
    }

    private int[] allocateTreeNode(Set<Integer> onlySet, Set<Integer> rwSet, int rootCount, int degree, long delay, int height) {
        int parentIdx;
        int[] result = new int[this.nodeIds.length];
        long[] writerInterval = new long[this.nodeIds.length];
        Arrays.fill(result, -2);
        HashMap<Integer, List> children = new HashMap<Integer, List>();
        LinkedList<Integer> notFullNodesIdx = new LinkedList<Integer>();
        for (Integer idx : onlySet) {
            if (children.size() < rootCount) {
                children.put(idx, new ArrayList());
                notFullNodesIdx.add(idx);
                result[idx.intValue()] = -1;
                continue;
            }
            parentIdx = (Integer)notFullNodesIdx.peek();
            children.computeIfAbsent(parentIdx, k -> new ArrayList()).add(idx);
            notFullNodesIdx.addLast(idx);
            if (((List)children.get(parentIdx)).size() >= degree) {
                notFullNodesIdx.pop();
            }
            writerInterval[idx.intValue()] = delay / (long)(height - 1);
        }
        for (Integer idx : rwSet) {
            if (children.size() < rootCount) {
                children.put(idx, new ArrayList());
                notFullNodesIdx.add(idx);
                result[idx.intValue()] = -1;
                continue;
            }
            parentIdx = (Integer)notFullNodesIdx.peek();
            children.computeIfAbsent(parentIdx, k -> new ArrayList()).add(idx);
            notFullNodesIdx.addLast(idx);
            if (((List)children.get(parentIdx)).size() >= degree) {
                notFullNodesIdx.pop();
            }
            writerInterval[idx.intValue()] = delay / (long)(height - 1);
        }
        for (Integer parentId : children.keySet()) {
            Iterator iterator = ((List)children.get(parentId)).iterator();
            while (iterator.hasNext()) {
                int childId = (Integer)iterator.next();
                result[childId] = parentId;
            }
        }
        return result;
    }

    public String toString() {
        String result = "[" + this.wDelay + "," + this.w2rDelay + "," + this.rDelay + "]\nwriter tree: degree " + this.treeDegreeW + ", count " + this.rootCountW + ",\nreader tree: degree " + this.treeDegreeR + ", count " + this.rootCountR;
        return result;
    }
}

