/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.memory;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Map;
import java.util.Random;
import java.util.zip.GZIPInputStream;
import javax.script.Bindings;
import org.bdware.sc.boundry.JavaScriptEntry;
import org.bdware.sc.boundry.Resources;
import org.bdware.sc.memory.MemoryDump;
import org.bdware.sc.memory.MemoryJSObject;
import org.bdware.sc.util.JsonUtil;
import wrp.jdk.nashorn.api.scripting.NashornScriptEngine;
import wrp.jdk.nashorn.api.scripting.ScriptObjectMirror;

public class MemoryRecoverUtil {
    NashornScriptEngine engine;
    String loadContent;
    MemoryDump memoryDump = null;
    Resources resource;

    public MemoryRecoverUtil(NashornScriptEngine en, Resources r) {
        this.engine = en;
        this.resource = r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadMemory(String path, boolean stateful) {
        NashornScriptEngine nashornScriptEngine = this.engine;
        synchronized (nashornScriptEngine) {
            File file = new File(path);
            try {
                long i;
                if (file.exists()) {
                    try {
                        FileInputStream fileout = new FileInputStream(file);
                        GZIPInputStream gzin = new GZIPInputStream(fileout);
                        ObjectInputStream reader = new ObjectInputStream(gzin);
                        MemoryDump temp = (MemoryDump)reader.readObject();
                        String content = JsonUtil.toPrettyJson(temp.objects);
                        temp.jseDump.printContent();
                        long invokeID = temp.jseDump.invokeID;
                        int copies = temp.jseDump.numsOfCopies;
                        long formerInvokeID = JavaScriptEntry.invokeID;
                        JavaScriptEntry.invokeID = invokeID;
                        JavaScriptEntry.numOfCopies = copies;
                        if (JavaScriptEntry.random == null) {
                            JavaScriptEntry.random = new Random();
                            JavaScriptEntry.random.setSeed(temp.jseDump.ranSeed);
                        }
                        if (formerInvokeID > invokeID) {
                            JavaScriptEntry.random = new Random();
                            JavaScriptEntry.random.setSeed(temp.jseDump.ranSeed);
                            for (i = 0L; i < invokeID; ++i) {
                                JavaScriptEntry.random.nextInt();
                            }
                        } else {
                            for (i = formerInvokeID; i < invokeID; ++i) {
                                JavaScriptEntry.random.nextInt();
                            }
                        }
                        if (stateful) {
                            this.memoryDump = temp;
                        }
                        reader.close();
                    }
                    catch (IOException | ClassNotFoundException e) {
                        e.printStackTrace();
                    }
                } else {
                    String[] strs = path.split("--seperate--");
                    String content = strs[0];
                    String jse = strs[1];
                    System.out.println("MemoryRecover\u4ece\u5b57\u7b26\u4e32load:\n" + content + "\n" + jse);
                    String[] strs2 = jse.split(";");
                    long invokeID = Long.parseLong(strs2[0]);
                    int copies = Integer.parseInt(strs2[2]);
                    long formerInvokeID = JavaScriptEntry.invokeID;
                    String contractID = strs2[1];
                    JavaScriptEntry.invokeID = invokeID;
                    JavaScriptEntry.numOfCopies = copies;
                    if (JavaScriptEntry.random == null) {
                        JavaScriptEntry.random = new Random();
                        JavaScriptEntry.random.setSeed(Integer.valueOf(contractID).intValue());
                    }
                    if (formerInvokeID > invokeID) {
                        JavaScriptEntry.random = new Random();
                        JavaScriptEntry.random.setSeed(Integer.valueOf(contractID).intValue());
                        for (i = 0L; i < invokeID; ++i) {
                            JavaScriptEntry.random.nextInt();
                        }
                    } else {
                        for (i = formerInvokeID; i < invokeID; ++i) {
                            JavaScriptEntry.random.nextInt();
                        }
                    }
                    if (stateful) {
                        this.memoryDump = MemoryDump.loadFromStr(content);
                    }
                }
                if (stateful) {
                    MemoryJSObject root = this.memoryDump.getRoot();
                    Map<Long, Object> objects = this.memoryDump.recreateObject();
                    ScriptObjectMirror global = (ScriptObjectMirror)objects.get(0L);
                    Bindings bindings = this.engine.getBindings(100);
                    for (String key : global.keySet()) {
                        if (global.get(key) == null) continue;
                        bindings.put(key, global.get(key));
                    }
                }
                this.memoryDump = null;
                if (this.resource != null) {
                    this.engine.invokeFunction("defineProp", "Resources", this.resource);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

