/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.datax.common.element;

import com.alibaba.datax.common.element.Column;
import com.alibaba.datax.common.element.OverFlowUtil;
import com.alibaba.datax.common.exception.CommonErrorCode;
import com.alibaba.datax.common.exception.DataXException;
import com.alibaba.datax.common.spi.ErrorCode;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;

public class DoubleColumn
extends Column {
    public DoubleColumn(String data) {
        this(data, null == data ? 0 : data.length());
        this.validate(data);
    }

    public DoubleColumn(Long data) {
        this(data == null ? (String)null : String.valueOf(data));
    }

    public DoubleColumn(Integer data) {
        this(data == null ? (String)null : String.valueOf(data));
    }

    public DoubleColumn(Double data) {
        this(data == null ? (String)null : new BigDecimal(String.valueOf(data)).toPlainString());
    }

    public DoubleColumn(Float data) {
        this(data == null ? (String)null : new BigDecimal(String.valueOf(data)).toPlainString());
    }

    public DoubleColumn(BigDecimal data) {
        this(null == data ? (String)null : data.toPlainString());
    }

    public DoubleColumn(BigInteger data) {
        this(null == data ? (String)null : data.toString());
    }

    public DoubleColumn() {
        this((String)null);
    }

    private DoubleColumn(String data, int byteSize) {
        super(data, Column.Type.DOUBLE, byteSize);
    }

    @Override
    public BigDecimal asBigDecimal() {
        if (null == this.getRawData()) {
            return null;
        }
        try {
            return new BigDecimal((String)this.getRawData());
        }
        catch (NumberFormatException e) {
            throw DataXException.asDataXException((ErrorCode)CommonErrorCode.CONVERT_NOT_SUPPORT, String.format("String[%s] \u65e0\u6cd5\u8f6c\u6362\u4e3aDouble\u7c7b\u578b .", (String)this.getRawData()));
        }
    }

    @Override
    public Double asDouble() {
        boolean isDoubleSpecific;
        if (null == this.getRawData()) {
            return null;
        }
        String string = (String)this.getRawData();
        boolean bl = isDoubleSpecific = string.equals("NaN") || string.equals("-Infinity") || string.equals("+Infinity");
        if (isDoubleSpecific) {
            return Double.valueOf(string);
        }
        BigDecimal result = this.asBigDecimal();
        OverFlowUtil.validateDoubleNotOverFlow(result);
        return result.doubleValue();
    }

    @Override
    public Long asLong() {
        if (null == this.getRawData()) {
            return null;
        }
        BigDecimal result = this.asBigDecimal();
        OverFlowUtil.validateLongNotOverFlow(result.toBigInteger());
        return result.longValue();
    }

    @Override
    public BigInteger asBigInteger() {
        if (null == this.getRawData()) {
            return null;
        }
        return this.asBigDecimal().toBigInteger();
    }

    @Override
    public String asString() {
        if (null == this.getRawData()) {
            return null;
        }
        return (String)this.getRawData();
    }

    @Override
    public Boolean asBoolean() {
        throw DataXException.asDataXException((ErrorCode)CommonErrorCode.CONVERT_NOT_SUPPORT, "Double\u7c7b\u578b\u65e0\u6cd5\u8f6c\u4e3aBool .");
    }

    @Override
    public Date asDate() {
        throw DataXException.asDataXException((ErrorCode)CommonErrorCode.CONVERT_NOT_SUPPORT, "Double\u7c7b\u578b\u65e0\u6cd5\u8f6c\u4e3aDate\u7c7b\u578b .");
    }

    @Override
    public byte[] asBytes() {
        throw DataXException.asDataXException((ErrorCode)CommonErrorCode.CONVERT_NOT_SUPPORT, "Double\u7c7b\u578b\u65e0\u6cd5\u8f6c\u4e3aBytes\u7c7b\u578b .");
    }

    private void validate(String data) {
        if (null == data) {
            return;
        }
        if (data.equalsIgnoreCase("NaN") || data.equalsIgnoreCase("-Infinity") || data.equalsIgnoreCase("Infinity")) {
            return;
        }
        try {
            new BigDecimal(data);
        }
        catch (Exception e) {
            throw DataXException.asDataXException((ErrorCode)CommonErrorCode.CONVERT_NOT_SUPPORT, String.format("String[%s]\u65e0\u6cd5\u8f6c\u4e3aDouble\u7c7b\u578b .", data));
        }
    }
}

