/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.datax.transport.transformer.maskingMethods.cryptology;

import com.alibaba.datax.transport.transformer.maskingConfigure.RSAKey;
import com.alibaba.datax.transport.transformer.maskingMethods.cryptology.CryptologyMasking;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.encodings.PKCS1Encoding;
import org.bouncycastle.crypto.engines.RSAEngine;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSAEncryptionImpl
extends CryptologyMasking {
    public static final int RAW = 2;
    public static final int PKCS1 = 1;
    private RSAPublicKey publicKey;
    private RSAPrivateKey privateKey;
    private KeyPair pair;
    private int keyLength = 1024;
    private static Logger logger = LoggerFactory.getLogger(RSAEncryptionImpl.class);

    public RSAEncryptionImpl(int keyLength) {
        this.keyLength = keyLength;
        this.generateRSAKeyPair();
    }

    public RSAEncryptionImpl() {
        this.generateRSAKeyPair();
    }

    private void generateRSAKeyPair() {
        try {
            this.publicKey = RSAKey.getPublicKey();
            this.privateKey = RSAKey.getPrivateKey();
        }
        catch (Exception e) {
            System.out.println("Exception in keypair generation. Reason: " + e);
        }
    }

    public void printRSAKeyPair() {
        try {
            KeyPairGenerator rsaKeyGen = KeyPairGenerator.getInstance("RSA");
            rsaKeyGen.initialize(this.keyLength, new SecureRandom());
            KeyPair Pair2 = rsaKeyGen.genKeyPair();
            System.out.println((RSAPublicKey)Pair2.getPublic());
            RSAPrivateKey priKey = (RSAPrivateKey)Pair2.getPrivate();
            RSAPublicKey rSAPublicKey = (RSAPublicKey)Pair2.getPublic();
        }
        catch (Exception e) {
            System.out.println("Exception in keypair generation. Reason: " + e);
        }
    }

    public byte[] publicEncrypt(byte[] clearBytes, int type) {
        BigInteger mod = this.publicKey.getModulus();
        BigInteger publicExponent = this.publicKey.getPublicExponent();
        RSAKeyParameters para = new RSAKeyParameters(false, mod, publicExponent);
        RSAEngine engine = new RSAEngine();
        if (type == 1) {
            engine = new PKCS1Encoding((AsymmetricBlockCipher)engine);
        }
        engine.init(true, (CipherParameters)para);
        try {
            byte[] data = engine.processBlock(clearBytes, 0, clearBytes.length);
            return data;
        }
        catch (InvalidCipherTextException e) {
            e.printStackTrace();
            logger.error("publicEncrypt engine.processBlock error");
            return null;
        }
    }

    public byte[] publicDecrypt(byte[] clearBytes, int type) {
        BigInteger mod = this.publicKey.getModulus();
        BigInteger pubExp = this.publicKey.getPublicExponent();
        RSAKeyParameters para = new RSAKeyParameters(false, mod, pubExp);
        RSAEngine engine = new RSAEngine();
        if (type == 1) {
            engine = new PKCS1Encoding((AsymmetricBlockCipher)engine);
        }
        engine.init(false, (CipherParameters)para);
        try {
            byte[] data = engine.processBlock(clearBytes, 0, clearBytes.length);
            return data;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("publicDecrypt engine.processBlock exception");
            return null;
        }
    }

    public byte[] privateDecrypt(byte[] encodedBytes, int type) {
        RSAPrivateCrtKey prvCrtKey = (RSAPrivateCrtKey)this.privateKey;
        BigInteger mod = prvCrtKey.getModulus();
        BigInteger pubExp = prvCrtKey.getPublicExponent();
        BigInteger privExp = prvCrtKey.getPrivateExponent();
        BigInteger pExp = prvCrtKey.getPrimeExponentP();
        BigInteger qExp = prvCrtKey.getPrimeExponentQ();
        BigInteger p = prvCrtKey.getPrimeP();
        BigInteger q = prvCrtKey.getPrimeQ();
        BigInteger crtCoef = prvCrtKey.getCrtCoefficient();
        RSAPrivateCrtKeyParameters para = new RSAPrivateCrtKeyParameters(mod, pubExp, privExp, p, q, pExp, qExp, crtCoef);
        RSAEngine engine = new RSAEngine();
        if (type == 1) {
            engine = new PKCS1Encoding((AsymmetricBlockCipher)engine);
        }
        engine.init(false, (CipherParameters)para);
        try {
            byte[] data = engine.processBlock(encodedBytes, 0, encodedBytes.length);
            return data;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.info("privateDecrypt engine.processBlock error");
            return null;
        }
    }

    public byte[] privateEncrypt(byte[] encodedBytes, int type) {
        RSAPrivateCrtKey prvCrtKey = (RSAPrivateCrtKey)this.privateKey;
        BigInteger mod = prvCrtKey.getModulus();
        BigInteger pubExp = prvCrtKey.getPublicExponent();
        BigInteger privExp = prvCrtKey.getPrivateExponent();
        BigInteger pExp = prvCrtKey.getPrimeExponentP();
        BigInteger qExp = prvCrtKey.getPrimeExponentQ();
        BigInteger p = prvCrtKey.getPrimeP();
        BigInteger q = prvCrtKey.getPrimeQ();
        BigInteger crtCoef = prvCrtKey.getCrtCoefficient();
        RSAPrivateCrtKeyParameters para = new RSAPrivateCrtKeyParameters(mod, pubExp, privExp, p, q, pExp, qExp, crtCoef);
        RSAEngine engine = new RSAEngine();
        if (type == 1) {
            engine = new PKCS1Encoding((AsymmetricBlockCipher)engine);
        }
        engine.init(true, (CipherParameters)para);
        try {
            byte[] data = engine.processBlock(encodedBytes, 0, encodedBytes.length);
            return data;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("privateEncrypt engine.processBlock error");
            return null;
        }
    }

    public String changeBytesToString(byte[] data) {
        return new String(Hex.encode((byte[])data));
    }

    @Override
    public double execute(double epsilon) throws Exception {
        return -1.0;
    }

    public String execute(String originData, int type) throws NoSuchAlgorithmException {
        byte[] cipher = this.publicEncrypt(originData.getBytes(), type);
        return this.changeBytesToString(cipher);
    }

    public List<String> execute(List<String> originData) throws Exception {
        ArrayList<String> cipherData = new ArrayList<String>();
        for (String str : originData) {
            String cipherStr = this.changeBytesToString(this.publicEncrypt(str.getBytes(), 1));
            cipherData.add(cipherStr);
        }
        return cipherData;
    }

    public String executeWithPublicDecrypt(String originData, int type) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        BigInteger origin = new BigInteger(originData, 16);
        byte[] cipher = this.publicDecrypt(origin.toByteArray(), type);
        String decoded = this.changeBytesToString(cipher);
        BigInteger raw_code = new BigInteger(decoded, 16);
        String result = new String(raw_code.toByteArray(), "ascii");
        return result;
    }

    public String executeWithPublicEncrypt(String originData, int type) throws NoSuchAlgorithmException {
        byte[] cipher = this.publicEncrypt(originData.getBytes(), type);
        return this.changeBytesToString(cipher);
    }

    public String executeWithPrivateDecrypt(String originData, int type) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        BigInteger origin = new BigInteger(originData, 16);
        byte[] cipher = this.privateDecrypt(origin.toByteArray(), type);
        String decoded = this.changeBytesToString(cipher);
        BigInteger raw_code = new BigInteger(decoded, 16);
        String result = new String(raw_code.toByteArray(), "ascii");
        return result;
    }

    public String executeWithPrivateEncrypt(String originData, int type) throws NoSuchAlgorithmException {
        byte[] cipher = this.privateEncrypt(originData.getBytes(), type);
        return this.changeBytesToString(cipher);
    }

    @Override
    public void mask() throws Exception {
    }

    public static void main(String[] args) {
        int i;
        RSAEncryptionImpl masker = new RSAEncryptionImpl();
        for (i = 0; i < 10; ++i) {
        }
        for (i = 0; i < 10; ++i) {
            String content = new String("BKG2I");
            RSAEncryptionImpl rsatest = new RSAEncryptionImpl();
            System.out.println("String\u52a0\u5bc6\u524d\uff1a" + content);
            System.out.println("\u5b57\u7b26\u4e32\uff1a" + rsatest.changeBytesToString(content.getBytes()));
            byte[] cipher = rsatest.publicEncrypt(content.getBytes(), 2);
            System.out.println("\u516c\u94a5\u52a0\u5bc6\u540e\uff1a" + rsatest.changeBytesToString(cipher));
            byte[] plain = rsatest.privateDecrypt(cipher, 2);
            System.out.println("\u89e3\u5bc6\u540e\uff1a" + new String(plain));
        }
    }
}

