/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.crdt;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class SharableVarState {
    private String myId;
    private SharableVarConfiguration sharableVarConfiguration;
    private Integer myIndex;
    private boolean readerFlag;
    private boolean writerFlag;
    private boolean readerRootFlag;
    private boolean writerRootFlag;
    private String writerParent;
    private List<String> readerChildren;
    private List<String> readerRoots;
    private Long writeInterval;
    private Long readerInterval;

    public SharableVarState(String myId, SharableVarConfiguration sharableVarConfiguration) {
        this.myId = myId;
        this.sharableVarConfiguration = sharableVarConfiguration;
        this.parseProperties();
    }

    private void parseProperties() {
        int i;
        for (int i2 = 0; i2 < this.sharableVarConfiguration.getNodeIds().length; ++i2) {
            if (!Objects.equals(this.sharableVarConfiguration.getNodeIds()[i2], this.myId)) continue;
            this.myIndex = i2;
            break;
        }
        if (this.myIndex == null) {
            return;
        }
        int writerParentIdx = this.sharableVarConfiguration.writerParents[this.myIndex];
        if (writerParentIdx == -1) {
            this.writerFlag = true;
            this.writerRootFlag = true;
        } else if (writerParentIdx >= 0) {
            this.writerFlag = true;
            this.writerParent = this.sharableVarConfiguration.nodeIds[writerParentIdx];
        }
        int readerParentIdx = this.sharableVarConfiguration.readerParents[this.myIndex];
        if (readerParentIdx == -1) {
            this.readerFlag = true;
            this.readerRootFlag = true;
        } else if (readerParentIdx >= 0) {
            this.readerFlag = true;
        }
        if (this.readerFlag) {
            this.readerChildren = new ArrayList<String>();
            for (i = 0; i < this.sharableVarConfiguration.readerParents.length; ++i) {
                if (this.sharableVarConfiguration.readerParents[i] != this.myIndex) continue;
                this.readerChildren.add(this.sharableVarConfiguration.nodeIds[i]);
            }
            this.readerInterval = this.sharableVarConfiguration.readerIntervals[this.myIndex];
        }
        if (this.writerFlag) {
            this.writeInterval = this.sharableVarConfiguration.writerIntervals[this.myIndex];
        }
        if (this.writerRootFlag) {
            this.readerRoots = new ArrayList<String>();
            for (i = 0; i < this.sharableVarConfiguration.readerParents.length; ++i) {
                if (this.sharableVarConfiguration.readerParents[i] != -1) continue;
                this.readerRoots.add(this.sharableVarConfiguration.nodeIds[i]);
            }
        }
    }

    public String getMyId() {
        return this.myId;
    }

    public void setMyId(String myId) {
        this.myId = myId;
    }

    public SharableVarConfiguration getSharableVarConfiguration() {
        return this.sharableVarConfiguration;
    }

    public void setSharableVarConfiguration(SharableVarConfiguration sharableVarConfiguration) {
        this.sharableVarConfiguration = sharableVarConfiguration;
    }

    public Integer getMyIndex() {
        return this.myIndex;
    }

    public void setMyIndex(Integer myIndex) {
        this.myIndex = myIndex;
    }

    public boolean isReaderFlag() {
        return this.readerFlag;
    }

    public void setReaderFlag(boolean readerFlag) {
        this.readerFlag = readerFlag;
    }

    public boolean isWriterFlag() {
        return this.writerFlag;
    }

    public void setWriterFlag(boolean writerFlag) {
        this.writerFlag = writerFlag;
    }

    public boolean isReaderRootFlag() {
        return this.readerRootFlag;
    }

    public void setReaderRootFlag(boolean readerRootFlag) {
        this.readerRootFlag = readerRootFlag;
    }

    public boolean isWriterRootFlag() {
        return this.writerRootFlag;
    }

    public void setWriterRootFlag(boolean writerRootFlag) {
        this.writerRootFlag = writerRootFlag;
    }

    public String getWriterParent() {
        return this.writerParent;
    }

    public void setWriterParent(String writerParent) {
        this.writerParent = writerParent;
    }

    public List<String> getReaderChildren() {
        return this.readerChildren;
    }

    public void setReaderChildren(List<String> readerChildren) {
        this.readerChildren = readerChildren;
    }

    public List<String> getReaderRoots() {
        return this.readerRoots;
    }

    public void setReaderRoots(List<String> readerRoots) {
        this.readerRoots = readerRoots;
    }

    public Long getWriteInterval() {
        return this.writeInterval;
    }

    public void setWriteInterval(Long writeInterval) {
        this.writeInterval = writeInterval;
    }

    public Long getReaderInterval() {
        return this.readerInterval;
    }

    public void setReaderInterval(Long readerInterval) {
        this.readerInterval = readerInterval;
    }

    public static void main(String[] args) {
        SharableVarConfiguration sharableVarConfiguration = new SharableVarConfiguration();
        sharableVarConfiguration.setNodeIds(new String[]{"/bdrepo1/var/0", "/bdrepo1/var/1", "/bdrepo1/var/2", "/bdrepo1/var/3"});
        sharableVarConfiguration.setWriterParents(new int[]{2, 2, -1, -2});
        sharableVarConfiguration.setReaderParents(new int[]{-2, -1, -2, 1});
        sharableVarConfiguration.setWriterIntervals(new long[]{5L, 5L, 6L, -1L});
        sharableVarConfiguration.setReaderIntervals(new long[]{-1L, 4L, -1L, -1L});
        SharableVarState sharableVarState0 = new SharableVarState("/bdrepo1/var/0", sharableVarConfiguration);
        SharableVarState sharableVarState1 = new SharableVarState("/bdrepo1/var/1", sharableVarConfiguration);
        SharableVarState sharableVarState2 = new SharableVarState("/bdrepo1/var/2", sharableVarConfiguration);
        SharableVarState sharableVarState3 = new SharableVarState("/bdrepo1/var/3", sharableVarConfiguration);
        System.out.println(sharableVarState0);
        System.out.println(sharableVarState1);
        System.out.println(sharableVarState2);
        System.out.println(sharableVarState3);
    }

    public static class SharableVarConfiguration {
        String[] nodeIds;
        long maxDelay;
        int[] writerIndexes;
        int[] readerIndexes;
        int[] writerParents;
        int[] readerParents;
        long[] writerIntervals;
        long[] readerIntervals;

        public String[] getNodeIds() {
            return this.nodeIds;
        }

        public void setNodeIds(String[] nodeIds) {
            this.nodeIds = nodeIds;
        }

        public long getMaxDelay() {
            return this.maxDelay;
        }

        public void setMaxDelay(long maxDelay) {
            this.maxDelay = maxDelay;
        }

        public int[] getWriterIndexes() {
            return this.writerIndexes;
        }

        public void setWriterIndexes(int[] writerIndexes) {
            this.writerIndexes = writerIndexes;
        }

        public int[] getReaderIndexes() {
            return this.readerIndexes;
        }

        public void setReaderIndexes(int[] readerIndexes) {
            this.readerIndexes = readerIndexes;
        }

        public int[] getWriterParents() {
            return this.writerParents;
        }

        public void setWriterParents(int[] writerParents) {
            this.writerParents = writerParents;
        }

        public int[] getReaderParents() {
            return this.readerParents;
        }

        public void setReaderParents(int[] readerParents) {
            this.readerParents = readerParents;
        }

        public long[] getWriterIntervals() {
            return this.writerIntervals;
        }

        public void setWriterIntervals(long[] writerIntervals) {
            this.writerIntervals = writerIntervals;
        }

        public long[] getReaderIntervals() {
            return this.readerIntervals;
        }

        public void setReaderIntervals(long[] readerIntervals) {
            this.readerIntervals = readerIntervals;
        }
    }
}

