/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.crdt.proxy;

import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.bdware.crdt.basic.JoinableCRDT;
import org.bdware.sc.crdt.SharableVarManager;
import org.bdware.sc.crdt.SharableVarState;
import org.bdware.sc.util.JsonUtil;

public abstract class SharableVar<T extends JoinableCRDT> {
    public T writerVar;
    public T readerVar;
    public Queue<JoinableCRDT> writerVarDeltaQueue;
    public Queue<JoinableCRDT> readerVarDeltaQueue;
    public String varId;
    public SharableVarState sharableVarState;
    public HashedWheelTimer readerTimer;
    public ReaderSyncTimerTask readerSyncTimerTask;
    public HashedWheelTimer writerTimer;
    public WriterSyncTimerTask writerSyncTimerTask;

    public SharableVar(String varId, String cpId, SharableVarState.SharableVarConfiguration resolveResult) {
        this.varId = varId;
        this.sharableVarState = new SharableVarState(cpId, resolveResult);
        if (this.sharableVarState.isReaderFlag()) {
            this.readerVar = this.createDeltaCrdt(cpId, varId);
            this.readerVarDeltaQueue = new LinkedList<JoinableCRDT>();
            if (this.sharableVarState.getReaderChildren() != null && this.sharableVarState.getReaderChildren().size() > 0 && this.sharableVarState.getReaderInterval() != null && this.sharableVarState.getReaderInterval() > 0L) {
                this.readerTimer = new HashedWheelTimer(r -> {
                    Thread t = Executors.defaultThreadFactory().newThread(r);
                    t.setDaemon(true);
                    return t;
                }, 5L, TimeUnit.MILLISECONDS, 2);
                this.readerTimer.newTimeout(timeout -> {
                    this.readerSyncTimerTask = new ReaderSyncTimerTask();
                    this.readerTimer.newTimeout((TimerTask)this.readerSyncTimerTask, this.sharableVarState.getReaderInterval().longValue(), TimeUnit.SECONDS);
                }, this.sharableVarState.getReaderInterval().longValue(), TimeUnit.SECONDS);
            }
        }
        if (this.sharableVarState.isWriterFlag()) {
            this.writerVar = this.createDeltaCrdt(cpId, varId);
            this.writerVarDeltaQueue = new LinkedList<JoinableCRDT>();
            if (this.sharableVarState.getWriteInterval() != null && this.sharableVarState.getWriteInterval() > 0L) {
                this.writerTimer = new HashedWheelTimer(r -> {
                    Thread t = Executors.defaultThreadFactory().newThread(r);
                    t.setDaemon(true);
                    return t;
                }, 5L, TimeUnit.MILLISECONDS, 2);
                this.writerTimer.newTimeout(timeout -> {
                    this.writerSyncTimerTask = new WriterSyncTimerTask();
                    this.writerTimer.newTimeout((TimerTask)this.writerSyncTimerTask, this.sharableVarState.getWriteInterval().longValue(), TimeUnit.SECONDS);
                }, this.sharableVarState.getWriteInterval().longValue(), TimeUnit.SECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncReaderVar() {
        if (this.readerVarDeltaQueue.isEmpty()) {
            return;
        }
        T joinedDelta = this.createDeltaCrdt(null, this.varId);
        Queue<JoinableCRDT> queue = this.readerVarDeltaQueue;
        synchronized (queue) {
            while (!this.readerVarDeltaQueue.isEmpty()) {
                JoinableCRDT delta = this.readerVarDeltaQueue.poll();
                joinedDelta.join((Object)delta);
            }
        }
        String content = JsonUtil.toJson(joinedDelta);
        SharableVarManager.instance.broadcastSyncMessage(this.varId, this.sharableVarState.getReaderChildren(), content, "r2r");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncWriterVar() {
        if (this.writerVarDeltaQueue.isEmpty()) {
            return;
        }
        T joinedDelta = this.createDeltaCrdt(null, this.varId);
        Queue<JoinableCRDT> queue = this.writerVarDeltaQueue;
        synchronized (queue) {
            while (!this.writerVarDeltaQueue.isEmpty()) {
                JoinableCRDT delta = this.writerVarDeltaQueue.poll();
                joinedDelta.join((Object)delta);
            }
        }
        String content = JsonUtil.toJson(joinedDelta);
        if (this.sharableVarState.getWriterParent() != null) {
            SharableVarManager.instance.broadcastSyncMessage(this.varId, Collections.singletonList(this.sharableVarState.getWriterParent()), content, "w2w");
        } else if (this.sharableVarState.getReaderRoots() != null) {
            SharableVarManager.instance.broadcastSyncMessage(this.varId, this.sharableVarState.getReaderRoots(), content, "w2r");
        }
    }

    protected abstract T createDeltaCrdt(String var1, String var2);

    class WriterSyncTimerTask
    implements TimerTask {
        WriterSyncTimerTask() {
        }

        public void run(Timeout timeout) throws Exception {
            try {
                SharableVar.this.syncWriterVar();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                SharableVar.this.writerTimer.newTimeout((TimerTask)SharableVar.this.writerSyncTimerTask, SharableVar.this.sharableVarState.getWriteInterval().longValue(), TimeUnit.SECONDS);
            }
        }
    }

    class ReaderSyncTimerTask
    implements TimerTask {
        ReaderSyncTimerTask() {
        }

        public void run(Timeout timeout) throws Exception {
            try {
                SharableVar.this.syncReaderVar();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                SharableVar.this.readerTimer.newTimeout((TimerTask)SharableVar.this.readerSyncTimerTask, SharableVar.this.sharableVarState.getReaderInterval().longValue(), TimeUnit.SECONDS);
            }
        }
    }
}

