/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.engine.hook;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.sc.JSEngine;
import org.bdware.sc.bean.ContractRequest;
import org.bdware.sc.boundry.ScriptReturnException;
import org.bdware.sc.engine.hook.ArgSchemaVisitor;
import org.bdware.sc.engine.hook.YJSAnnotation;
import org.bdware.sc.node.AnnotationHook;
import org.bdware.sc.node.AnnotationNode;
import org.bdware.sc.node.ArgPacks;
import org.bdware.sc.node.FunctionNode;

@YJSAnnotation(name="ArgSchema")
public class ArgSchemaHandler
implements AnnotationHook {
    private AnnotationNode a;
    private static final Logger LOGGER = LogManager.getLogger(ArgSchemaHandler.class);

    public ArgSchemaHandler(AnnotationNode annoNode) {
        this.a = annoNode;
        String arg = (String)this.a.getArgs().get(0);
    }

    public static ArgSchemaHandler fromAnnotationNode(FunctionNode funNode, AnnotationNode annoNode) {
        return new ArgSchemaHandler(annoNode);
    }

    public ArgPacks handle(JSEngine Engine2, ArgPacks argPacks) throws ScriptReturnException {
        JsonObject jo;
        ArgSchemaVisitor visitor;
        ContractRequest input = argPacks.request;
        JsonElement je = input.getArg();
        if (je.isJsonObject()) {
            visitor = new ArgSchemaVisitor(input.getArg().getAsJsonObject());
        } else {
            try {
                JsonElement obj = JsonParser.parseString(input.getArg().getAsString());
                visitor = new ArgSchemaVisitor(obj);
                input.setArg(obj);
                argPacks.arg = obj;
            }
            catch (Exception e) {
                e.printStackTrace();
                JsonObject jo2 = new JsonObject();
                jo2.addProperty("msg", "[Illegal Type] argument should be JSON");
                jo2.addProperty("code", 1004);
                throw new ScriptReturnException(jo2);
            }
        }
        if (je.toString().isEmpty() && !((String)this.a.getArgs().get(0)).equals("")) {
            jo = new JsonObject();
            jo.addProperty("msg", "[Empty argument] argument should not be empty");
            jo.addProperty("code", 1003);
            throw new ScriptReturnException(jo);
        }
        visitor.visit(JsonParser.parseString((String)this.a.getArgs().get(0)));
        if (!visitor.getStatus()) {
            jo = new JsonObject();
            jo.addProperty("msg", visitor.getException());
            jo.addProperty("code", visitor.errorCode);
            jo.add("argSchema", JsonParser.parseString((String)this.a.getArgs().get(0)));
            throw new ScriptReturnException(jo);
        }
        return argPacks;
    }
}

