/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.handler;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.netty.channel.ChannelHandlerContext;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.doip.codec.JsonDoipMessage;
import org.bdware.doip.codec.doipMessage.DoipMessage;
import org.bdware.doip.codec.doipMessage.DoipMessageFactory;
import org.bdware.doip.codec.doipMessage.DoipResponseCode;
import org.bdware.doip.codec.doipMessage.HeaderParameter;
import org.bdware.doip.codec.operations.BasicOperations;
import org.bdware.doip.endpoint.server.DoipRequestHandler;
import org.bdware.doip.endpoint.server.NettyServerHandler;
import org.bdware.sc.ContractProcess;
import org.bdware.sc.bean.ContractRequest;
import org.bdware.sc.boundry.JavaScriptEntry;
import org.bdware.sc.crdt.SharableVarManager;
import org.bdware.sc.entity.DoipMessagePacker;
import org.bdware.sc.node.FunctionNode;
import org.bdware.sc.util.JsonUtil;

public class DOOPRequestHandler
implements DoipRequestHandler {
    static Logger logger = LogManager.getLogger(NettyServerHandler.class);
    public Map<String, FunctionNode> doipFunctionNodeMap = new HashMap<String, FunctionNode>();

    public void addDoipOperation(FunctionNode function) throws Exception {
        String operationName = function.getDoipOperationInfo().operationName;
        if (this.doipFunctionNodeMap.containsKey(operationName)) {
            throw new Exception("Contract is wrong: One DO operation maps multiple functions");
        }
        this.doipFunctionNodeMap.put(operationName, function);
    }

    public DoipMessage onRequest(ChannelHandlerContext ctx, DoipMessage msg) {
        String str = msg.header.parameters.operation;
        if (msg.header != null && msg.header.parameters.operation.equals("86.100871/SyncVar")) {
            return SharableVarManager.instance.handleSyncMessage(msg);
        }
        logger.debug("[Call operation] name: " + str);
        if (str != null) {
            FunctionNode fn = this.doipFunctionNodeMap.get(str);
            if (fn == null) {
                fn = this.doipFunctionNodeMap.get(BasicOperations.Unknown.getName());
            }
            if (fn != null) {
                return this.buildRequestAndInvokeEngine(fn, msg);
            }
        }
        return null;
    }

    public DoipMessage buildRequestAndInvokeEngine(FunctionNode fn, DoipMessage msg) {
        ContractRequest contractRequest = this.constructContractRequest(fn, msg);
        DoipMessagePacker arg = new DoipMessagePacker("doip", msg);
        try {
            Object ret = ContractProcess.instance.engine.executeWithoutLock(fn, contractRequest, arg);
            DoipMessage finalDoipMsg = (DoipMessage)ret;
            finalDoipMsg.requestID = msg.requestID;
            if (finalDoipMsg.header.parameters == null) {
                finalDoipMsg.header.parameters = new HeaderParameter("", "");
            }
            if (finalDoipMsg.header.parameters.attributes == null) {
                finalDoipMsg.header.parameters.attributes = new JsonObject();
            }
            finalDoipMsg.header.parameters.attributes.addProperty("nodeID", String.valueOf(JavaScriptEntry.shardingID));
            return finalDoipMsg;
        }
        catch (Exception e) {
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream(bo));
            DoipMessageFactory.DoipMessageBuilder builder = new DoipMessageFactory.DoipMessageBuilder();
            builder.createResponse(DoipResponseCode.Declined, msg);
            builder.setBody(bo.toByteArray());
            builder.addAttributes("nodeID", String.valueOf(JavaScriptEntry.shardingID));
            logger.error("buildRequestAndInvokeEngine has something wrong, executeWithoutLock err or validateJsonElementRulesByArgSchemaVisitor err");
            return builder.create();
        }
    }

    public ContractRequest constructContractRequest(FunctionNode fn, DoipMessage request) {
        ContractRequest cr = new ContractRequest();
        cr.setContractID("");
        if (request.credential == null) {
            cr.setRequester(null);
        } else {
            cr.setRequester(request.credential.getSigner());
        }
        cr.setAction(fn.functionName);
        cr.setArg((JsonElement)JsonUtil.parseObjectAsJsonObject((Object)JsonDoipMessage.fromDoipMessage((DoipMessage)request)));
        return cr;
    }
}

