/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.datax.core.transport.transformer;

import com.alibaba.datax.common.element.BoolColumn;
import com.alibaba.datax.common.element.BytesColumn;
import com.alibaba.datax.common.element.Column;
import com.alibaba.datax.common.element.DateColumn;
import com.alibaba.datax.common.element.DoubleColumn;
import com.alibaba.datax.common.element.LongColumn;
import com.alibaba.datax.common.element.Record;
import com.alibaba.datax.common.element.StringColumn;
import com.alibaba.datax.common.exception.DataXException;
import com.alibaba.datax.common.spi.ErrorCode;
import com.alibaba.datax.core.transport.transformer.TransformerErrorCode;
import com.alibaba.datax.transport.transformer.Transformer;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;

public class FilterTransformer
extends Transformer {
    public FilterTransformer() {
        this.setTransformerName("dx_filter");
    }

    @Override
    public Record evaluate(Record record, Object ... paras) {
        String value;
        String code;
        int columnIndex;
        try {
            if (paras.length != 3) {
                throw new RuntimeException("dx_filter paras must be 3");
            }
            columnIndex = (Integer)paras[0];
            code = (String)paras[1];
            value = (String)paras[2];
            if (StringUtils.isEmpty((CharSequence)value)) {
                throw new RuntimeException("dx_filter para 2 can't be null");
            }
        }
        catch (Exception e) {
            throw DataXException.asDataXException((ErrorCode)TransformerErrorCode.TRANSFORMER_ILLEGAL_PARAMETER, "paras:" + Arrays.asList(paras).toString() + " => " + e.getMessage());
        }
        Column column = record.getColumn(columnIndex);
        try {
            if (code.equalsIgnoreCase("like")) {
                return this.doLike(record, value, column);
            }
            if (code.equalsIgnoreCase("not like")) {
                return this.doNotLike(record, value, column);
            }
            if (code.equalsIgnoreCase(">")) {
                return this.doGreat(record, value, column, false);
            }
            if (code.equalsIgnoreCase("<")) {
                return this.doLess(record, value, column, false);
            }
            if (code.equalsIgnoreCase("=") || code.equalsIgnoreCase("==")) {
                return this.doEqual(record, value, column);
            }
            if (code.equalsIgnoreCase("!=")) {
                return this.doNotEqual(record, value, column);
            }
            if (code.equalsIgnoreCase(">=")) {
                return this.doGreat(record, value, column, true);
            }
            if (code.equalsIgnoreCase("<=")) {
                return this.doLess(record, value, column, true);
            }
            throw new RuntimeException("dx_filter can't suport code:" + code);
        }
        catch (Exception e) {
            throw DataXException.asDataXException(TransformerErrorCode.TRANSFORMER_RUN_EXCEPTION, e.getMessage(), e);
        }
    }

    private Record doGreat(Record record, String value, Column column, boolean hasEqual) {
        if (column.getRawData() == null) {
            return record;
        }
        if (column instanceof DoubleColumn) {
            Double ori = column.asDouble();
            double val = Double.parseDouble(value);
            if (hasEqual) {
                if (ori >= val) {
                    return null;
                }
                return record;
            }
            if (ori > val) {
                return null;
            }
            return record;
        }
        if (column instanceof LongColumn || column instanceof DateColumn) {
            Long ori = column.asLong();
            long val = Long.parseLong(value);
            if (hasEqual) {
                if (ori >= val) {
                    return null;
                }
                return record;
            }
            if (ori > val) {
                return null;
            }
            return record;
        }
        if (column instanceof StringColumn || column instanceof BytesColumn || column instanceof BoolColumn) {
            String ori = column.asString();
            if (hasEqual) {
                if (ori.compareTo(value) >= 0) {
                    return null;
                }
                return record;
            }
            if (ori.compareTo(value) > 0) {
                return null;
            }
            return record;
        }
        throw new RuntimeException(">=,> can't support this columnType:" + column.getClass().getSimpleName());
    }

    private Record doLess(Record record, String value, Column column, boolean hasEqual) {
        if (column.getRawData() == null) {
            return record;
        }
        if (column instanceof DoubleColumn) {
            Double ori = column.asDouble();
            double val = Double.parseDouble(value);
            if (hasEqual) {
                if (ori <= val) {
                    return null;
                }
                return record;
            }
            if (ori < val) {
                return null;
            }
            return record;
        }
        if (column instanceof LongColumn || column instanceof DateColumn) {
            Long ori = column.asLong();
            long val = Long.parseLong(value);
            if (hasEqual) {
                if (ori <= val) {
                    return null;
                }
                return record;
            }
            if (ori < val) {
                return null;
            }
            return record;
        }
        if (column instanceof StringColumn || column instanceof BytesColumn || column instanceof BoolColumn) {
            String ori = column.asString();
            if (hasEqual) {
                if (ori.compareTo(value) <= 0) {
                    return null;
                }
                return record;
            }
            if (ori.compareTo(value) < 0) {
                return null;
            }
            return record;
        }
        throw new RuntimeException("<=,< can't support this columnType:" + column.getClass().getSimpleName());
    }

    private Record doEqual(Record record, String value, Column column) {
        if (column.getRawData() == null) {
            if (value.equalsIgnoreCase("null")) {
                return null;
            }
            return record;
        }
        if (column instanceof DoubleColumn) {
            Double ori = column.asDouble();
            double val = Double.parseDouble(value);
            if (ori == val) {
                return null;
            }
            return record;
        }
        if (column instanceof LongColumn || column instanceof DateColumn) {
            Long ori = column.asLong();
            long val = Long.parseLong(value);
            if (ori == val) {
                return null;
            }
            return record;
        }
        if (column instanceof StringColumn || column instanceof BytesColumn || column instanceof BoolColumn) {
            String ori = column.asString();
            if (ori.compareTo(value) == 0) {
                return null;
            }
            return record;
        }
        throw new RuntimeException("== can't support this columnType:" + column.getClass().getSimpleName());
    }

    private Record doNotEqual(Record record, String value, Column column) {
        if (column.getRawData() == null) {
            if (value.equalsIgnoreCase("null")) {
                return record;
            }
            return null;
        }
        if (column instanceof DoubleColumn) {
            Double ori = column.asDouble();
            double val = Double.parseDouble(value);
            if (ori != val) {
                return null;
            }
            return record;
        }
        if (column instanceof LongColumn || column instanceof DateColumn) {
            Long ori = column.asLong();
            long val = Long.parseLong(value);
            if (ori != val) {
                return null;
            }
            return record;
        }
        if (column instanceof StringColumn || column instanceof BytesColumn || column instanceof BoolColumn) {
            String ori = column.asString();
            if (ori.compareTo(value) != 0) {
                return null;
            }
            return record;
        }
        throw new RuntimeException("== can't support this columnType:" + column.getClass().getSimpleName());
    }

    private Record doLike(Record record, String value, Column column) {
        String orivalue = column.asString();
        if (orivalue != null && orivalue.matches(value)) {
            return null;
        }
        return record;
    }

    private Record doNotLike(Record record, String value, Column column) {
        String orivalue = column.asString();
        if (orivalue != null && orivalue.matches(value)) {
            return record;
        }
        return null;
    }
}

