/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.datax.plugin.rdbms.reader.util;

import com.alibaba.datax.common.exception.DataXException;
import com.alibaba.datax.common.util.Configuration;
import com.alibaba.datax.plugin.rdbms.reader.util.SingleTableSplitUtil;
import com.alibaba.datax.plugin.rdbms.util.DBUtil;
import com.alibaba.datax.plugin.rdbms.util.DataBaseType;
import com.alibaba.datax.plugin.rdbms.util.RdbmsException;
import com.alibaba.druid.sql.parser.ParserException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.List;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreCheckTask
implements Callable<Boolean> {
    private static final Logger LOG = LoggerFactory.getLogger(PreCheckTask.class);
    private String userName;
    private String password;
    private String splitPkId;
    private Configuration connection;
    private DataBaseType dataBaseType;

    public PreCheckTask(String userName, String password, Configuration connection, DataBaseType dataBaseType, String splitPkId) {
        this.connection = connection;
        this.userName = userName;
        this.password = password;
        this.dataBaseType = dataBaseType;
        this.splitPkId = splitPkId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean call() throws DataXException {
        String jdbcUrl = this.connection.getString("jdbcUrl");
        List<Object> querySqls = this.connection.getList("querySql", Object.class);
        List<Object> splitPkSqls = this.connection.getList("splitPkSql", Object.class);
        List<Object> tables = this.connection.getList("table", Object.class);
        Connection conn = DBUtil.getConnectionWithoutRetry(this.dataBaseType, jdbcUrl, this.userName, this.password);
        int fetchSize = 1;
        if (DataBaseType.MySql.equals((Object)this.dataBaseType) || DataBaseType.DRDS.equals((Object)this.dataBaseType)) {
            fetchSize = Integer.MIN_VALUE;
        }
        try {
            for (int i = 0; i < querySqls.size(); ++i) {
                String splitPkSql = null;
                String querySql = querySqls.get(i).toString();
                String table = null;
                if (tables != null && !tables.isEmpty()) {
                    table = tables.get(i).toString();
                }
                ResultSet rs = null;
                try {
                    DBUtil.sqlValid(querySql, this.dataBaseType);
                    if (i == 0) {
                        rs = DBUtil.query(conn, querySql, fetchSize);
                    }
                }
                catch (ParserException e) {
                    throw RdbmsException.asSqlParserException(this.dataBaseType, (Exception)((Object)e), querySql);
                }
                catch (Exception e) {
                    throw RdbmsException.asQueryException(this.dataBaseType, e, querySql, table, this.userName);
                }
                finally {
                    DBUtil.closeDBResources(rs, null, null);
                }
                try {
                    if (splitPkSqls == null || splitPkSqls.isEmpty()) continue;
                    splitPkSql = splitPkSqls.get(i).toString();
                    DBUtil.sqlValid(splitPkSql, this.dataBaseType);
                    if (i != 0) continue;
                    SingleTableSplitUtil.precheckSplitPk(conn, splitPkSql, fetchSize, table, this.userName);
                    continue;
                }
                catch (ParserException e) {
                    throw RdbmsException.asSqlParserException(this.dataBaseType, (Exception)((Object)e), splitPkSql);
                }
                catch (DataXException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw RdbmsException.asSplitPKException(this.dataBaseType, e, splitPkSql, this.splitPkId.trim());
                }
            }
        }
        finally {
            DBUtil.closeDBResources(null, conn);
        }
        return true;
    }
}

