/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.datax.plugin.rdbms.reader.util;

import com.alibaba.datax.common.constant.CommonConstant;
import com.alibaba.datax.common.util.Configuration;
import com.alibaba.datax.plugin.rdbms.reader.Constant;
import com.alibaba.datax.plugin.rdbms.reader.util.HintUtil;
import com.alibaba.datax.plugin.rdbms.reader.util.SingleTableSplitUtil;
import com.alibaba.datax.plugin.rdbms.util.DataBaseType;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReaderSplitUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ReaderSplitUtil.class);

    public static List<Configuration> doSplit(Configuration originalSliceConfig, int adviceNumber) {
        boolean isTableMode = originalSliceConfig.getBool(Constant.IS_TABLE_MODE);
        int eachTableShouldSplittedNumber = -1;
        if (isTableMode) {
            eachTableShouldSplittedNumber = ReaderSplitUtil.calculateEachTableShouldSplittedNumber(adviceNumber, originalSliceConfig.getInt(Constant.TABLE_NUMBER_MARK));
        }
        String column = originalSliceConfig.getString("column");
        String where = originalSliceConfig.getString("where", null);
        List<Object> conns = originalSliceConfig.getList(Constant.CONN_MARK, Object.class);
        ArrayList<Configuration> splittedConfigs = new ArrayList<Configuration>();
        int len = conns.size();
        for (int i = 0; i < len; ++i) {
            Configuration tempSlice;
            Configuration sliceConfig = originalSliceConfig.clone();
            Configuration connConf = Configuration.from(conns.get(i).toString());
            String jdbcUrl = connConf.getString("jdbcUrl");
            sliceConfig.set("jdbcUrl", jdbcUrl);
            sliceConfig.set(CommonConstant.LOAD_BALANCE_RESOURCE_MARK, DataBaseType.parseIpFromJdbcUrl(jdbcUrl));
            sliceConfig.remove(Constant.CONN_MARK);
            if (isTableMode) {
                boolean needSplitTable;
                List<String> tables = connConf.getList("table", String.class);
                Validate.isTrue((null != tables && !tables.isEmpty() ? 1 : 0) != 0, (String)"\u60a8\u8bfb\u53d6\u6570\u636e\u5e93\u8868\u914d\u7f6e\u9519\u8bef.", (Object[])new Object[0]);
                String splitPk = originalSliceConfig.getString("splitPk", null);
                boolean bl = needSplitTable = eachTableShouldSplittedNumber > 1 && StringUtils.isNotBlank((CharSequence)splitPk);
                if (needSplitTable) {
                    if (tables.size() == 1) {
                        eachTableShouldSplittedNumber *= 5;
                    }
                    for (String table : tables) {
                        tempSlice = sliceConfig.clone();
                        tempSlice.set("table", table);
                        List<Configuration> splittedSlices = SingleTableSplitUtil.splitSingleTable(tempSlice, eachTableShouldSplittedNumber);
                        splittedConfigs.addAll(splittedSlices);
                    }
                    continue;
                }
                for (String table : tables) {
                    tempSlice = sliceConfig.clone();
                    tempSlice.set("table", table);
                    String queryColumn = HintUtil.buildQueryColumn(jdbcUrl, table, column);
                    tempSlice.set("querySql", SingleTableSplitUtil.buildQuerySql(queryColumn, table, where));
                    splittedConfigs.add(tempSlice);
                }
                continue;
            }
            List<String> sqls = connConf.getList("querySql", String.class);
            for (String querySql : sqls) {
                tempSlice = sliceConfig.clone();
                tempSlice.set("querySql", querySql);
                splittedConfigs.add(tempSlice);
            }
        }
        return splittedConfigs;
    }

    public static Configuration doPreCheckSplit(Configuration originalSliceConfig) {
        Configuration queryConfig = originalSliceConfig.clone();
        boolean isTableMode = originalSliceConfig.getBool(Constant.IS_TABLE_MODE);
        String splitPK = originalSliceConfig.getString("splitPk");
        String column = originalSliceConfig.getString("column");
        String where = originalSliceConfig.getString("where", null);
        List<Object> conns = queryConfig.getList(Constant.CONN_MARK, Object.class);
        int len = conns.size();
        for (int i = 0; i < len; ++i) {
            Configuration connConf = Configuration.from(conns.get(i).toString());
            ArrayList<String> querys = new ArrayList<String>();
            ArrayList<String> splitPkQuerys = new ArrayList<String>();
            String connPath = String.format("connection[%d]", i);
            if (isTableMode) {
                List<String> tables = connConf.getList("table", String.class);
                Validate.isTrue((null != tables && !tables.isEmpty() ? 1 : 0) != 0, (String)"\u60a8\u8bfb\u53d6\u6570\u636e\u5e93\u8868\u914d\u7f6e\u9519\u8bef.", (Object[])new Object[0]);
                for (String table : tables) {
                    querys.add(SingleTableSplitUtil.buildQuerySql(column, table, where));
                    if (splitPK == null || splitPK.isEmpty()) continue;
                    splitPkQuerys.add(SingleTableSplitUtil.genPKSql(splitPK.trim(), table, where));
                }
                if (!splitPkQuerys.isEmpty()) {
                    connConf.set("splitPkSql", splitPkQuerys);
                }
                connConf.set("querySql", querys);
                queryConfig.set(connPath, connConf);
                continue;
            }
            List<String> sqls = connConf.getList("querySql", String.class);
            for (String querySql : sqls) {
                querys.add(querySql);
            }
            connConf.set("querySql", querys);
            queryConfig.set(connPath, connConf);
        }
        return queryConfig;
    }

    private static int calculateEachTableShouldSplittedNumber(int adviceNumber, int tableNumber) {
        double tempNum = 1.0 * (double)adviceNumber / (double)tableNumber;
        return (int)Math.ceil(tempNum);
    }
}

