/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.datax.plugin.rdbms.writer.util;

import com.alibaba.datax.common.exception.DataXException;
import com.alibaba.datax.common.spi.ErrorCode;
import com.alibaba.datax.common.util.Configuration;
import com.alibaba.datax.common.util.ListUtil;
import com.alibaba.datax.plugin.rdbms.util.ConnectionFactory;
import com.alibaba.datax.plugin.rdbms.util.DBUtil;
import com.alibaba.datax.plugin.rdbms.util.DBUtilErrorCode;
import com.alibaba.datax.plugin.rdbms.util.DataBaseType;
import com.alibaba.datax.plugin.rdbms.util.JdbcConnectionFactory;
import com.alibaba.datax.plugin.rdbms.util.TableExpandUtil;
import com.alibaba.datax.plugin.rdbms.writer.Constant;
import com.alibaba.datax.plugin.rdbms.writer.util.WriterUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OriginalConfPretreatmentUtil {
    private static final Logger LOG = LoggerFactory.getLogger(OriginalConfPretreatmentUtil.class);
    public static DataBaseType DATABASE_TYPE;

    public static void doPretreatment(Configuration originalConfig, DataBaseType dataBaseType) {
        originalConfig.getNecessaryValue("username", DBUtilErrorCode.REQUIRED_VALUE);
        originalConfig.getNecessaryValue("password", DBUtilErrorCode.REQUIRED_VALUE);
        OriginalConfPretreatmentUtil.doCheckBatchSize(originalConfig);
        OriginalConfPretreatmentUtil.simplifyConf(originalConfig);
        OriginalConfPretreatmentUtil.dealColumnConf(originalConfig);
        OriginalConfPretreatmentUtil.dealWriteMode(originalConfig, dataBaseType);
    }

    public static void doCheckBatchSize(Configuration originalConfig) {
        int batchSize = originalConfig.getInt("batchSize", 2048);
        if (batchSize < 1) {
            throw DataXException.asDataXException((ErrorCode)DBUtilErrorCode.ILLEGAL_VALUE, String.format("\u60a8\u7684batchSize\u914d\u7f6e\u6709\u8bef. \u60a8\u6240\u914d\u7f6e\u7684\u5199\u5165\u6570\u636e\u5e93\u8868\u7684 batchSize:%s \u4e0d\u80fd\u5c0f\u4e8e1. \u63a8\u8350\u914d\u7f6e\u8303\u56f4\u4e3a\uff1a[100-1000], \u8be5\u503c\u8d8a\u5927, \u5185\u5b58\u6ea2\u51fa\u53ef\u80fd\u6027\u8d8a\u5927. \u8bf7\u68c0\u67e5\u60a8\u7684\u914d\u7f6e\u5e76\u4f5c\u51fa\u4fee\u6539.", batchSize));
        }
        originalConfig.set("batchSize", batchSize);
    }

    public static void simplifyConf(Configuration originalConfig) {
        List<Object> connections = originalConfig.getList(Constant.CONN_MARK, Object.class);
        int tableNum = 0;
        int len = connections.size();
        for (int i = 0; i < len; ++i) {
            Configuration connConf = Configuration.from(connections.get(i).toString());
            String jdbcUrl = connConf.getString("jdbcUrl");
            if (StringUtils.isBlank((CharSequence)jdbcUrl)) {
                throw DataXException.asDataXException((ErrorCode)DBUtilErrorCode.REQUIRED_VALUE, "\u60a8\u672a\u914d\u7f6e\u7684\u5199\u5165\u6570\u636e\u5e93\u8868\u7684 jdbcUrl.");
            }
            jdbcUrl = DATABASE_TYPE.appendJDBCSuffixForReader(jdbcUrl);
            originalConfig.set(String.format("%s[%d].%s", Constant.CONN_MARK, i, "jdbcUrl"), jdbcUrl);
            List<String> tables = connConf.getList("table", String.class);
            if (null == tables || tables.isEmpty()) {
                throw DataXException.asDataXException((ErrorCode)DBUtilErrorCode.REQUIRED_VALUE, "\u60a8\u672a\u914d\u7f6e\u5199\u5165\u6570\u636e\u5e93\u8868\u7684\u8868\u540d\u79f0. \u6839\u636e\u914d\u7f6eDataX\u627e\u4e0d\u5230\u60a8\u914d\u7f6e\u7684\u8868. \u8bf7\u68c0\u67e5\u60a8\u7684\u914d\u7f6e\u5e76\u4f5c\u51fa\u4fee\u6539.");
            }
            List<String> expandedTables = TableExpandUtil.expandTableConf(DATABASE_TYPE, tables);
            if (null == expandedTables || expandedTables.isEmpty()) {
                throw DataXException.asDataXException((ErrorCode)DBUtilErrorCode.CONF_ERROR, "\u60a8\u914d\u7f6e\u7684\u5199\u5165\u6570\u636e\u5e93\u8868\u540d\u79f0\u9519\u8bef. DataX\u627e\u4e0d\u5230\u60a8\u914d\u7f6e\u7684\u8868\uff0c\u8bf7\u68c0\u67e5\u60a8\u7684\u914d\u7f6e\u5e76\u4f5c\u51fa\u4fee\u6539.");
            }
            tableNum += expandedTables.size();
            originalConfig.set(String.format("%s[%d].%s", Constant.CONN_MARK, i, "table"), expandedTables);
        }
        originalConfig.set(Constant.TABLE_NUMBER_MARK, tableNum);
    }

    public static void dealColumnConf(Configuration originalConfig, ConnectionFactory connectionFactory, String oneTable) {
        List<String> userConfiguredColumns = originalConfig.getList("column", String.class);
        if (null == userConfiguredColumns || userConfiguredColumns.isEmpty()) {
            throw DataXException.asDataXException((ErrorCode)DBUtilErrorCode.ILLEGAL_VALUE, "\u60a8\u7684\u914d\u7f6e\u6587\u4ef6\u4e2d\u7684\u5217\u914d\u7f6e\u4fe1\u606f\u6709\u8bef. \u56e0\u4e3a\u60a8\u672a\u914d\u7f6e\u5199\u5165\u6570\u636e\u5e93\u8868\u7684\u5217\u540d\u79f0\uff0cDataX\u83b7\u53d6\u4e0d\u5230\u5217\u4fe1\u606f. \u8bf7\u68c0\u67e5\u60a8\u7684\u914d\u7f6e\u5e76\u4f5c\u51fa\u4fee\u6539.");
        }
        boolean isPreCheck = originalConfig.getBool("dryRun", false);
        List<String> allColumns = isPreCheck ? DBUtil.getTableColumnsByConn(DATABASE_TYPE, connectionFactory.getConnecttionWithoutRetry(), oneTable, connectionFactory.getConnectionInfo()) : DBUtil.getTableColumnsByConn(DATABASE_TYPE, connectionFactory.getConnecttion(), oneTable, connectionFactory.getConnectionInfo());
        LOG.info("table:[{}] all columns:[\n{}\n].", (Object)oneTable, (Object)StringUtils.join(allColumns, (String)","));
        if (1 == userConfiguredColumns.size() && "*".equals(userConfiguredColumns.get(0))) {
            LOG.warn("\u60a8\u7684\u914d\u7f6e\u6587\u4ef6\u4e2d\u7684\u5217\u914d\u7f6e\u4fe1\u606f\u5b58\u5728\u98ce\u9669. \u56e0\u4e3a\u60a8\u914d\u7f6e\u7684\u5199\u5165\u6570\u636e\u5e93\u8868\u7684\u5217\u4e3a*\uff0c\u5f53\u60a8\u7684\u8868\u5b57\u6bb5\u4e2a\u6570\u3001\u7c7b\u578b\u6709\u53d8\u52a8\u65f6\uff0c\u53ef\u80fd\u5f71\u54cd\u4efb\u52a1\u6b63\u786e\u6027\u751a\u81f3\u4f1a\u8fd0\u884c\u51fa\u9519\u3002\u8bf7\u68c0\u67e5\u60a8\u7684\u914d\u7f6e\u5e76\u4f5c\u51fa\u4fee\u6539.");
            originalConfig.set("column", allColumns);
        } else {
            if (userConfiguredColumns.size() > allColumns.size()) {
                throw DataXException.asDataXException((ErrorCode)DBUtilErrorCode.ILLEGAL_VALUE, String.format("\u60a8\u7684\u914d\u7f6e\u6587\u4ef6\u4e2d\u7684\u5217\u914d\u7f6e\u4fe1\u606f\u6709\u8bef. \u56e0\u4e3a\u60a8\u6240\u914d\u7f6e\u7684\u5199\u5165\u6570\u636e\u5e93\u8868\u7684\u5b57\u6bb5\u4e2a\u6570:%s \u5927\u4e8e\u76ee\u7684\u8868\u7684\u603b\u5b57\u6bb5\u603b\u4e2a\u6570:%s. \u8bf7\u68c0\u67e5\u60a8\u7684\u914d\u7f6e\u5e76\u4f5c\u51fa\u4fee\u6539.", userConfiguredColumns.size(), allColumns.size()));
            }
            ListUtil.makeSureNoValueDuplicate(userConfiguredColumns, false);
            DBUtil.getColumnMetaData(connectionFactory.getConnecttion(), oneTable, StringUtils.join(userConfiguredColumns, (String)","));
        }
    }

    public static void dealColumnConf(Configuration originalConfig) {
        String jdbcUrl = originalConfig.getString(String.format("%s[0].%s", Constant.CONN_MARK, "jdbcUrl"));
        String username = originalConfig.getString("username");
        String password = originalConfig.getString("password");
        String oneTable = originalConfig.getString(String.format("%s[0].%s[0]", Constant.CONN_MARK, "table"));
        JdbcConnectionFactory jdbcConnectionFactory = new JdbcConnectionFactory(DATABASE_TYPE, jdbcUrl, username, password);
        OriginalConfPretreatmentUtil.dealColumnConf(originalConfig, jdbcConnectionFactory, oneTable);
    }

    public static void dealWriteMode(Configuration originalConfig, DataBaseType dataBaseType) {
        List<String> columns = originalConfig.getList("column", String.class);
        String jdbcUrl = originalConfig.getString(String.format("%s[0].%s", Constant.CONN_MARK, "jdbcUrl", String.class));
        String writeMode = originalConfig.getString("writeMode", "INSERT");
        ArrayList<String> valueHolders = new ArrayList<String>(columns.size());
        for (int i = 0; i < columns.size(); ++i) {
            valueHolders.add("?");
        }
        boolean forceUseUpdate = false;
        if (dataBaseType == DataBaseType.MySql && OriginalConfPretreatmentUtil.isOB10(jdbcUrl)) {
            forceUseUpdate = true;
        }
        String writeDataSqlTemplate = WriterUtil.getWriteTemplate(columns, valueHolders, writeMode, dataBaseType, forceUseUpdate);
        LOG.info("Write data [\n{}\n], which jdbcUrl like:[{}]", (Object)writeDataSqlTemplate, (Object)jdbcUrl);
        originalConfig.set(Constant.INSERT_OR_REPLACE_TEMPLATE_MARK, writeDataSqlTemplate);
    }

    public static boolean isOB10(String jdbcUrl) {
        if (jdbcUrl.startsWith("||_dsc_ob10_dsc_||")) {
            String[] ss = jdbcUrl.split("\\|\\|_dsc_ob10_dsc_\\|\\|");
            if (ss.length != 3) {
                throw DataXException.asDataXException((ErrorCode)DBUtilErrorCode.JDBC_OB10_ADDRESS_ERROR, "JDBC OB10\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u8054\u7cfbaskdatax");
            }
            return true;
        }
        return false;
    }
}

