/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.crdt;

import com.google.gson.JsonElement;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.crdt.basic.JoinableCRDT;
import org.bdware.doip.audit.AuditDoaClient;
import org.bdware.doip.audit.EndpointConfig;
import org.bdware.doip.audit.client.AuditDoipClient;
import org.bdware.doip.audit.client.AuditIrpClient;
import org.bdware.doip.codec.JsonDoipMessage;
import org.bdware.doip.codec.doipMessage.DoipMessage;
import org.bdware.doip.codec.doipMessage.DoipMessageFactory;
import org.bdware.doip.codec.doipMessage.DoipResponseCode;
import org.bdware.doip.endpoint.client.DoipMessageCallback;
import org.bdware.irp.client.IrpClient;
import org.bdware.irp.stateinfo.StateInfoBase;
import org.bdware.sc.crdt.SharableVarState;
import org.bdware.sc.crdt.proxy.AWORSetProxy;
import org.bdware.sc.crdt.proxy.DWFlagProxy;
import org.bdware.sc.crdt.proxy.GCounterProxy;
import org.bdware.sc.crdt.proxy.GSetProxy;
import org.bdware.sc.crdt.proxy.LWWRegisterProxy;
import org.bdware.sc.crdt.proxy.MVRegisterProxy;
import org.bdware.sc.crdt.proxy.PNCounterProxy;
import org.bdware.sc.crdt.proxy.RWLWWSetProxy;
import org.bdware.sc.crdt.proxy.RWORSetProxy;
import org.bdware.sc.crdt.proxy.SharableVar;
import org.bdware.sc.crdt.proxy.TPSetProxy;
import org.bdware.sc.util.JsonUtil;

public class SharableVarManager {
    static Logger LOGGER = LogManager.getLogger(SharableVarManager.class);
    public static SharableVarManager instance;
    public final String cpId;
    Map<String, SharableVar> allVars = new ConcurrentHashMap<String, SharableVar>();
    IrpClient client;
    AuditDoaClient doaClient;
    public static final String SHARABLEOP = "86.100871/SyncVar";

    public SharableVarManager(String cpId, EndpointConfig config) {
        this.client = new AuditIrpClient(config);
        this.doaClient = new AuditDoaClient("", config, null);
        this.cpId = cpId;
    }

    public static void initSharableVarManager(String id, EndpointConfig config) {
        if (instance == null) {
            instance = new SharableVarManager(id, config);
        }
    }

    public DoipMessage handleSyncMessage(DoipMessage message) {
        try {
            String varId = message.header.parameters.attributes.get("varId").getAsString();
            String content = message.header.parameters.attributes.get("content").getAsString();
            String type = message.header.parameters.attributes.get("type").getAsString();
            SharableVar var = this.allVars.get(varId);
            if (var != null) {
                JoinableCRDT delta;
                if (Objects.equals(type, "r2r") || Objects.equals(type, "w2r")) {
                    delta = (JoinableCRDT)JsonUtil.fromJson((String)content, var.readerVar.getClass());
                    var.readerVar.join((Object)delta);
                    var.readerVarDeltaQueue.add(delta);
                } else if (Objects.equals(type, "w2w")) {
                    delta = (JoinableCRDT)JsonUtil.fromJson((String)content, var.writerVar.getClass());
                    var.writerVar.join((Object)delta);
                    var.writerVarDeltaQueue.add(delta);
                }
            }
            DoipMessageFactory.DoipMessageBuilder builder = new DoipMessageFactory.DoipMessageBuilder();
            builder.createResponse(DoipResponseCode.Success, message);
            builder.addAttributes("msg", "success");
            return builder.create();
        }
        catch (Exception e) {
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            e.printStackTrace();
            e.printStackTrace(new PrintStream(bo));
            DoipMessageFactory.DoipMessageBuilder builder = new DoipMessageFactory.DoipMessageBuilder();
            builder.createResponse(DoipResponseCode.UnKnownError, message);
            builder.addAttributes("exception", bo.toString());
            return builder.create();
        }
    }

    private DoipMessage createSyncMessage(String target, String varId, String content, String type) {
        DoipMessageFactory.DoipMessageBuilder builder = new DoipMessageFactory.DoipMessageBuilder();
        builder.createRequest(target, SHARABLEOP);
        builder.addAttributes("varId", varId);
        builder.addAttributes("content", content);
        builder.addAttributes("type", type);
        return builder.create();
    }

    public void broadcastSyncMessage(String varId, List<String> sendTo, String content, String type) {
        for (String target : sendTo) {
            DoipMessage doipMessage = this.createSyncMessage(target, varId, content, type);
            if (target.equals(this.cpId)) {
                LOGGER.info("Handle Sync locally:" + JsonUtil.toJson((Object)JsonDoipMessage.fromDoipMessage((DoipMessage)doipMessage)));
                this.handleSyncMessage(doipMessage);
                continue;
            }
            AuditDoipClient client = this.getClient(target);
            client.sendMessage(doipMessage, new DoipMessageCallback(){

                public void onResult(DoipMessage doipMessage) {
                    LOGGER.info("RECV Sync:" + JsonUtil.toJson((Object)JsonDoipMessage.fromDoipMessage((DoipMessage)doipMessage)));
                }
            });
        }
    }

    private AuditDoipClient getClient(String id) {
        return this.doaClient.convertDoidToRepo(id);
    }

    public synchronized SharableVar createVar(String identifier, String type) {
        try {
            if (this.allVars.containsKey(identifier)) {
                return this.allVars.get(identifier);
            }
            StateInfoBase stateInfoBase = this.client.resolve(identifier);
            if (stateInfoBase.handleValues.has("bdwType") && stateInfoBase.handleValues.get("bdwType").getAsString().equals("SharableVar")) {
                SharableVarState.SharableVarConfiguration sharableVarConf = (SharableVarState.SharableVarConfiguration)JsonUtil.fromJson((JsonElement)stateInfoBase.handleValues, SharableVarState.SharableVarConfiguration.class);
                SharableVar sharableVar = this.createSharableVar(sharableVarConf, identifier, type);
                if (sharableVar != null) {
                    this.allVars.put(identifier, sharableVar);
                }
                return sharableVar;
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private SharableVar createSharableVar(SharableVarState.SharableVarConfiguration conf, String identifier, String type) {
        switch (type) {
            case "gcounter": {
                return new GCounterProxy(identifier, this.cpId, conf);
            }
            case "pncounter": {
                return new PNCounterProxy(identifier, this.cpId, conf);
            }
            case "dwflag": {
                return new DWFlagProxy(identifier, this.cpId, conf);
            }
            case "lwwregister": {
                return new LWWRegisterProxy(identifier, this.cpId, conf);
            }
            case "mvregister": {
                return new MVRegisterProxy(identifier, this.cpId, conf);
            }
            case "gset": {
                return new GSetProxy(identifier, this.cpId, conf);
            }
            case "tpset": {
                return new TPSetProxy(identifier, this.cpId, conf);
            }
            case "aworset": {
                return new AWORSetProxy(identifier, this.cpId, conf);
            }
            case "rworset": {
                return new RWORSetProxy(identifier, this.cpId, conf);
            }
            case "rwlwwset": {
                return new RWLWWSetProxy(identifier, this.cpId, conf);
            }
        }
        return null;
    }
}

