/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.crdt.planning;

import org.bdware.sc.crdt.planning.PlanningWith0Expansivity;
import org.bdware.sc.crdt.planning.PlanningWith1Expansivity;
import org.bdware.sc.crdt.planning.PlanningWithkExpansivity;

public class PlanningTest {
    public static void main(String[] args) {
        int nodeIdsCount = 1000;
        int writerCount = 500;
        int readerCount = 500;
        String[] nodeIds = new String[1000];
        int[] writers = new int[500];
        int[] readers = new int[500];
        for (int i = 0; i < 1000; ++i) {
            nodeIds[i] = "node_" + i;
            if (i < 500) {
                writers[i] = i;
            }
            if (i < 500) continue;
            readers[i - 1000 + 500] = i;
        }
        long maxDelay = 300L;
        int bandwidthUpload = 30;
        int bandwidthDownload = 30;
        int datasize = 10;
        double domainSize = 100 * datasize;
        PlanningWith0Expansivity planning0 = new PlanningWith0Expansivity(nodeIds, writers, readers, maxDelay, bandwidthDownload, bandwidthUpload, datasize);
        PlanningWithkExpansivity planningK = new PlanningWithkExpansivity(nodeIds, writers, readers, maxDelay, bandwidthDownload, bandwidthUpload, datasize, domainSize);
        PlanningWith1Expansivity planning1 = new PlanningWith1Expansivity(nodeIds, writers, readers, maxDelay, bandwidthDownload, bandwidthUpload, datasize);
        long start = System.currentTimeMillis();
        planning0.adjustAndCalc();
        planning0.allocate();
        long end = System.currentTimeMillis();
        System.out.println("took " + (end - start));
        System.out.println();
        start = System.currentTimeMillis();
        planningK.adjustAndCalc();
        planningK.allocate();
        end = System.currentTimeMillis();
        System.out.println("took " + (end - start));
        System.out.println();
        start = System.currentTimeMillis();
        planning1.adjustAndCalc();
        planning1.allocate();
        end = System.currentTimeMillis();
        System.out.println("took " + (end - start));
    }
}

