/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.trace;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.bdware.sc.trace.JSArray;
import org.bdware.sc.trace.JSObject;
import org.bdware.sc.trace.JSScript;
import org.bdware.sc.trace.Trace;
import wrp.jdk.nashorn.internal.runtime.Property;

public class TraceSetup
extends Trace
implements Serializable {
    JSScript obj;
    List<Property> properties;

    public TraceSetup(JSScript o) {
        this.obj = o;
        this.properties = new ArrayList<Property>();
    }

    public JSScript getObj() {
        return this.obj;
    }

    public void add(Property p) {
        this.properties.add(p);
    }

    public Property get(int i) {
        return this.properties.get(i);
    }

    public int proLength() {
        return this.properties.size();
    }

    @Override
    public String traceContent() {
        StringBuilder str = new StringBuilder();
        str.append("[TraceSetup]\n");
        if (this.obj instanceof JSObject) {
            str.append(((JSObject)this.obj).getObjID() + "," + ((JSObject)this.obj).getClass() + " \n");
        } else if (this.obj instanceof JSArray) {
            str.append(((JSArray)this.obj).getObjID() + "," + ((JSArray)this.obj).getClass() + " \n");
        }
        if (this.properties.size() > 0) {
            str.append("properties : \n");
            for (int i = 0; i < this.properties.size(); ++i) {
                str.append(this.properties.get(i) + "\n");
            }
        }
        return str.toString();
    }
}

