/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.datax.core.taskgroup.runner;

import com.alibaba.datax.common.plugin.AbstractTaskPlugin;
import com.alibaba.datax.common.plugin.TaskPluginCollector;
import com.alibaba.datax.common.util.Configuration;
import com.alibaba.datax.core.statistics.communication.Communication;
import com.alibaba.datax.dataxservice.face.domain.enums.State;
import org.apache.commons.lang.Validate;

public abstract class AbstractRunner {
    private AbstractTaskPlugin plugin;
    private Configuration jobConf;
    private Communication runnerCommunication;
    private int taskGroupId;
    private int taskId;

    public AbstractRunner(AbstractTaskPlugin taskPlugin) {
        this.plugin = taskPlugin;
    }

    public void destroy() {
        if (this.plugin != null) {
            this.plugin.destroy();
        }
    }

    public State getRunnerState() {
        return this.runnerCommunication.getState();
    }

    public AbstractTaskPlugin getPlugin() {
        return this.plugin;
    }

    public void setPlugin(AbstractTaskPlugin plugin) {
        this.plugin = plugin;
    }

    public Configuration getJobConf() {
        return this.jobConf;
    }

    public void setJobConf(Configuration jobConf) {
        this.jobConf = jobConf;
        this.plugin.setPluginJobConf(jobConf);
    }

    public void setTaskPluginCollector(TaskPluginCollector pluginCollector) {
        this.plugin.setTaskPluginCollector(pluginCollector);
    }

    private void mark(State state) {
        this.runnerCommunication.setState(state);
        if (state == State.SUCCEEDED) {
            this.runnerCommunication.setLongCounter("stage", this.runnerCommunication.getLongCounter("stage") + 1L);
        }
    }

    public void markRun() {
        this.mark(State.RUNNING);
    }

    public void markSuccess() {
        this.mark(State.SUCCEEDED);
    }

    public void markFail(Throwable throwable) {
        this.mark(State.FAILED);
        this.runnerCommunication.setTimestamp(System.currentTimeMillis());
        this.runnerCommunication.setThrowable(throwable);
    }

    public void setTaskGroupId(int taskGroupId) {
        this.taskGroupId = taskGroupId;
        this.plugin.setTaskGroupId(taskGroupId);
    }

    public int getTaskGroupId() {
        return this.taskGroupId;
    }

    public int getTaskId() {
        return this.taskId;
    }

    public void setTaskId(int taskId) {
        this.taskId = taskId;
        this.plugin.setTaskId(taskId);
    }

    public void setRunnerCommunication(Communication runnerCommunication) {
        Validate.notNull((Object)runnerCommunication, (String)"\u63d2\u4ef6\u7684Communication\u4e0d\u80fd\u4e3a\u7a7a");
        this.runnerCommunication = runnerCommunication;
    }

    public Communication getRunnerCommunication() {
        return this.runnerCommunication;
    }

    public abstract void shutdown();
}

