/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.datax.core.util;

import com.alibaba.datax.common.exception.DataXException;
import com.alibaba.datax.common.spi.ErrorCode;
import com.alibaba.datax.common.util.Configuration;
import com.alibaba.datax.core.util.FrameworkErrorCode;
import com.alibaba.datax.core.util.HttpClientUtil;
import com.alibaba.datax.core.util.SecretUtil;
import com.alibaba.datax.core.util.container.CoreConstant;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigParser {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigParser.class);

    public static Configuration parse(String jobPath) {
        Configuration configuration = ConfigParser.parseJobConfig(jobPath);
        configuration.merge(ConfigParser.parseCoreConfig(CoreConstant.DATAX_CONF_PATH), false);
        String readerPluginName = configuration.getString("job.content[0].reader.name");
        String writerPluginName = configuration.getString("job.content[0].writer.name");
        String preHandlerName = configuration.getString("job.preHandler.pluginName");
        String postHandlerName = configuration.getString("job.postHandler.pluginName");
        HashSet<String> pluginList = new HashSet<String>();
        pluginList.add(readerPluginName);
        pluginList.add(writerPluginName);
        if (StringUtils.isNotEmpty((String)preHandlerName)) {
            pluginList.add(preHandlerName);
        }
        if (StringUtils.isNotEmpty((String)postHandlerName)) {
            pluginList.add(postHandlerName);
        }
        try {
            configuration.merge(ConfigParser.parsePluginConfig(new ArrayList<String>(pluginList)), false);
        }
        catch (Exception e) {
            LOG.warn(String.format("\u63d2\u4ef6[%s,%s]\u52a0\u8f7d\u5931\u8d25\uff0c1s\u540e\u91cd\u8bd5... Exception:%s ", readerPluginName, writerPluginName, e.getMessage()));
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            configuration.merge(ConfigParser.parsePluginConfig(new ArrayList<String>(pluginList)), false);
        }
        return configuration;
    }

    private static Configuration parseCoreConfig(String path) {
        return Configuration.from(new File(path));
    }

    public static Configuration parseJobConfig(String path) {
        String jobContent = ConfigParser.getJobContent(path);
        Configuration config = Configuration.from(jobContent);
        return SecretUtil.decryptSecretKey(config);
    }

    private static String getJobContent(String jobResource) {
        String jobContent;
        boolean isJobResourceFromHttp = jobResource.trim().toLowerCase().startsWith("http");
        if (isJobResourceFromHttp) {
            Configuration coreConfig = ConfigParser.parseCoreConfig(CoreConstant.DATAX_CONF_PATH);
            int httpTimeOutInMillionSeconds = coreConfig.getInt("core.dataXServer.timeout", 5000);
            HttpClientUtil.setHttpTimeoutInMillionSeconds(httpTimeOutInMillionSeconds);
            HttpClientUtil httpClientUtil = new HttpClientUtil();
            try {
                URL url = new URL(jobResource);
                HttpGet httpGet = HttpClientUtil.getGetRequest();
                httpGet.setURI(url.toURI());
                jobContent = httpClientUtil.executeAndGetWithFailedRetry((HttpRequestBase)httpGet, 1, 1000L);
            }
            catch (Exception e) {
                throw DataXException.asDataXException(FrameworkErrorCode.CONFIG_ERROR, "\u83b7\u53d6\u4f5c\u4e1a\u914d\u7f6e\u4fe1\u606f\u5931\u8d25:" + jobResource, e);
            }
        }
        try {
            jobContent = FileUtils.readFileToString((File)new File(jobResource));
        }
        catch (IOException e) {
            throw DataXException.asDataXException(FrameworkErrorCode.CONFIG_ERROR, "\u83b7\u53d6\u4f5c\u4e1a\u914d\u7f6e\u4fe1\u606f\u5931\u8d25:" + jobResource, e);
        }
        if (jobContent == null) {
            throw DataXException.asDataXException((ErrorCode)FrameworkErrorCode.CONFIG_ERROR, "\u83b7\u53d6\u4f5c\u4e1a\u914d\u7f6e\u4fe1\u606f\u5931\u8d25:" + jobResource);
        }
        return jobContent;
    }

    public static Configuration parsePluginConfig(List<String> wantPluginNames) {
        Configuration configuration = Configuration.newDefault();
        HashSet<String> replicaCheckPluginSet = new HashSet<String>();
        int complete = 0;
        for (String each : ConfigParser.getDirAsList(CoreConstant.DATAX_PLUGIN_READER_HOME)) {
            Configuration eachReaderConfig = ConfigParser.parseOnePluginConfig(each, "reader", replicaCheckPluginSet, wantPluginNames);
            if (eachReaderConfig == null) continue;
            configuration.merge(eachReaderConfig, true);
            ++complete;
        }
        for (String each : ConfigParser.getDirAsList(CoreConstant.DATAX_PLUGIN_WRITER_HOME)) {
            Configuration eachWriterConfig = ConfigParser.parseOnePluginConfig(each, "writer", replicaCheckPluginSet, wantPluginNames);
            if (eachWriterConfig == null) continue;
            configuration.merge(eachWriterConfig, true);
            ++complete;
        }
        if (wantPluginNames != null && wantPluginNames.size() > 0 && wantPluginNames.size() != complete) {
            throw DataXException.asDataXException((ErrorCode)FrameworkErrorCode.PLUGIN_INIT_ERROR, "\u63d2\u4ef6\u52a0\u8f7d\u5931\u8d25\uff0c\u672a\u5b8c\u6210\u6307\u5b9a\u63d2\u4ef6\u52a0\u8f7d:" + wantPluginNames);
        }
        return configuration;
    }

    public static Configuration parseOnePluginConfig(String path, String type, Set<String> pluginSet, List<String> wantPluginNames) {
        String filePath = path + File.separator + "plugin.json";
        Configuration configuration = Configuration.from(new File(filePath));
        String pluginPath = configuration.getString("path");
        String pluginName = configuration.getString("name");
        if (pluginSet.contains(pluginName)) {
            throw DataXException.asDataXException((ErrorCode)FrameworkErrorCode.PLUGIN_INIT_ERROR, "\u63d2\u4ef6\u52a0\u8f7d\u5931\u8d25,\u5b58\u5728\u91cd\u590d\u63d2\u4ef6:" + filePath);
        }
        pluginSet.add(pluginName);
        if (wantPluginNames != null && wantPluginNames.size() > 0 && !wantPluginNames.contains(pluginName)) {
            return null;
        }
        boolean isDefaultPath = StringUtils.isBlank((String)pluginPath);
        if (isDefaultPath) {
            configuration.set("path", path);
        }
        Configuration result = Configuration.newDefault();
        result.set(String.format("plugin.%s.%s", type, pluginName), configuration.getInternal());
        return result;
    }

    private static List<String> getDirAsList(String path) {
        ArrayList<String> result = new ArrayList<String>();
        String[] paths = new File(path).list();
        if (null == paths) {
            return result;
        }
        for (String each : paths) {
            result.add(path + File.separator + each);
        }
        return result;
    }
}

