/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.datax.dataxservice.face.domain.enums;

import com.alibaba.datax.dataxservice.face.domain.enums.EnumStrVal;

public enum ExecuteMode implements EnumStrVal
{
    STANDALONE("standalone"),
    LOCAL("local"),
    DISTRIBUTE("distribute");

    String value;

    private ExecuteMode(String value) {
        this.value = value;
    }

    @Override
    public String value() {
        return this.value;
    }

    public String getValue() {
        return this.value;
    }

    public static boolean isLocal(String mode) {
        return ExecuteMode.equalsIgnoreCase(LOCAL.getValue(), mode);
    }

    public static boolean isDistribute(String mode) {
        return ExecuteMode.equalsIgnoreCase(DISTRIBUTE.getValue(), mode);
    }

    public static ExecuteMode toExecuteMode(String modeName) {
        for (ExecuteMode mode : ExecuteMode.values()) {
            if (!mode.value().equals(modeName)) continue;
            return mode;
        }
        throw new RuntimeException("no such mode :" + modeName);
    }

    private static boolean equalsIgnoreCase(String str1, String str2) {
        return str1 == null ? str2 == null : str1.equalsIgnoreCase(str2);
    }

    public String toString() {
        return this.value;
    }
}

