/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.datax.plugin.rdbms.reader.util;

import com.alibaba.datax.common.exception.DataXException;
import com.alibaba.datax.common.spi.ErrorCode;
import com.alibaba.datax.common.util.Configuration;
import com.alibaba.datax.plugin.rdbms.reader.Constant;
import com.alibaba.datax.plugin.rdbms.util.DBUtil;
import com.alibaba.datax.plugin.rdbms.util.DBUtilErrorCode;
import com.alibaba.datax.plugin.rdbms.util.DataBaseType;
import com.alibaba.datax.plugin.rdbms.util.RdbmsException;
import com.alibaba.datax.plugin.rdbms.util.RdbmsRangeSplitWrap;
import com.alibaba.fastjson.JSON;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleTableSplitUtil {
    private static final Logger LOG = LoggerFactory.getLogger(SingleTableSplitUtil.class);
    public static DataBaseType DATABASE_TYPE;

    private SingleTableSplitUtil() {
    }

    public static List<Configuration> splitSingleTable(Configuration configuration, int adviceNum) {
        Configuration tempConfig;
        String tempQuerySql;
        List<String> rangeList;
        ArrayList<Configuration> pluginParams = new ArrayList<Configuration>();
        String splitPkName = configuration.getString("splitPk");
        String column = configuration.getString("column");
        String table = configuration.getString("table");
        String where = configuration.getString("where", null);
        boolean hasWhere = StringUtils.isNotBlank((CharSequence)where);
        if (DATABASE_TYPE == DataBaseType.Oracle) {
            rangeList = SingleTableSplitUtil.genSplitSqlForOracle(splitPkName, table, where, configuration, adviceNum);
        } else {
            Pair<Object, Object> minMaxPK = SingleTableSplitUtil.getPkRange(configuration);
            if (null == minMaxPK) {
                throw DataXException.asDataXException((ErrorCode)DBUtilErrorCode.ILLEGAL_SPLIT_PK, "\u6839\u636e\u5207\u5206\u4e3b\u952e\u5207\u5206\u8868\u5931\u8d25. DataX \u4ec5\u652f\u6301\u5207\u5206\u4e3b\u952e\u4e3a\u4e00\u4e2a,\u5e76\u4e14\u7c7b\u578b\u4e3a\u6574\u6570\u6216\u8005\u5b57\u7b26\u4e32\u7c7b\u578b. \u8bf7\u5c1d\u8bd5\u4f7f\u7528\u5176\u4ed6\u7684\u5207\u5206\u4e3b\u952e\u6216\u8005\u8054\u7cfb DBA \u8fdb\u884c\u5904\u7406.");
            }
            configuration.set("querySql", SingleTableSplitUtil.buildQuerySql(column, table, where));
            if (null == minMaxPK.getLeft() || null == minMaxPK.getRight()) {
                pluginParams.add(configuration);
                return pluginParams;
            }
            boolean isStringType = Constant.PK_TYPE_STRING.equals(configuration.getString("pkType"));
            boolean isLongType = Constant.PK_TYPE_LONG.equals(configuration.getString("pkType"));
            if (isStringType) {
                rangeList = RdbmsRangeSplitWrap.splitAndWrap(String.valueOf(minMaxPK.getLeft()), String.valueOf(minMaxPK.getRight()), adviceNum, splitPkName, "'", DATABASE_TYPE);
            } else if (isLongType) {
                rangeList = RdbmsRangeSplitWrap.splitAndWrap(new BigInteger(minMaxPK.getLeft().toString()), new BigInteger(minMaxPK.getRight().toString()), adviceNum, splitPkName);
            } else {
                throw DataXException.asDataXException((ErrorCode)DBUtilErrorCode.ILLEGAL_SPLIT_PK, "\u60a8\u914d\u7f6e\u7684\u5207\u5206\u4e3b\u952e(splitPk) \u7c7b\u578b DataX \u4e0d\u652f\u6301. DataX \u4ec5\u652f\u6301\u5207\u5206\u4e3b\u952e\u4e3a\u4e00\u4e2a,\u5e76\u4e14\u7c7b\u578b\u4e3a\u6574\u6570\u6216\u8005\u5b57\u7b26\u4e32\u7c7b\u578b. \u8bf7\u5c1d\u8bd5\u4f7f\u7528\u5176\u4ed6\u7684\u5207\u5206\u4e3b\u952e\u6216\u8005\u8054\u7cfb DBA \u8fdb\u884c\u5904\u7406.");
            }
        }
        ArrayList<String> allQuerySql = new ArrayList<String>();
        if (null != rangeList && !rangeList.isEmpty()) {
            for (String range : rangeList) {
                Configuration tempConfig2 = configuration.clone();
                tempQuerySql = SingleTableSplitUtil.buildQuerySql(column, table, where) + (hasWhere ? " and " : " where ") + range;
                allQuerySql.add(tempQuerySql);
                tempConfig2.set("querySql", tempQuerySql);
                pluginParams.add(tempConfig2);
            }
        } else {
            tempConfig = configuration.clone();
            tempQuerySql = SingleTableSplitUtil.buildQuerySql(column, table, where) + (hasWhere ? " and " : " where ") + String.format(" %s IS NOT NULL", splitPkName);
            allQuerySql.add(tempQuerySql);
            tempConfig.set("querySql", tempQuerySql);
            pluginParams.add(tempConfig);
        }
        tempConfig = configuration.clone();
        tempQuerySql = SingleTableSplitUtil.buildQuerySql(column, table, where) + (hasWhere ? " and " : " where ") + String.format(" %s IS NULL", splitPkName);
        allQuerySql.add(tempQuerySql);
        LOG.info("After split(), allQuerySql=[\n{}\n].", (Object)StringUtils.join(allQuerySql, (String)"\n"));
        tempConfig.set("querySql", tempQuerySql);
        pluginParams.add(tempConfig);
        return pluginParams;
    }

    public static String buildQuerySql(String column, String table, String where) {
        String querySql = StringUtils.isBlank((CharSequence)where) ? String.format(Constant.QUERY_SQL_TEMPLATE_WITHOUT_WHERE, column, table) : String.format(Constant.QUERY_SQL_TEMPLATE, column, table, where);
        return querySql;
    }

    private static Pair<Object, Object> getPkRange(Configuration configuration) {
        String pkRangeSQL = SingleTableSplitUtil.genPKRangeSQL(configuration);
        int fetchSize = configuration.getInt("fetchSize");
        String jdbcURL = configuration.getString("jdbcUrl");
        String username = configuration.getString("username");
        String password = configuration.getString("password");
        String table = configuration.getString("table");
        Connection conn = DBUtil.getConnection(DATABASE_TYPE, jdbcURL, username, password);
        Pair<Object, Object> minMaxPK = SingleTableSplitUtil.checkSplitPk(conn, pkRangeSQL, fetchSize, table, username, configuration);
        DBUtil.closeDBResources(null, null, conn);
        return minMaxPK;
    }

    public static void precheckSplitPk(Connection conn, String pkRangeSQL, int fetchSize, String table, String username) {
        Pair<Object, Object> minMaxPK = SingleTableSplitUtil.checkSplitPk(conn, pkRangeSQL, fetchSize, table, username, null);
        if (null == minMaxPK) {
            throw DataXException.asDataXException((ErrorCode)DBUtilErrorCode.ILLEGAL_SPLIT_PK, "\u6839\u636e\u5207\u5206\u4e3b\u952e\u5207\u5206\u8868\u5931\u8d25. DataX \u4ec5\u652f\u6301\u5207\u5206\u4e3b\u952e\u4e3a\u4e00\u4e2a,\u5e76\u4e14\u7c7b\u578b\u4e3a\u6574\u6570\u6216\u8005\u5b57\u7b26\u4e32\u7c7b\u578b. \u8bf7\u5c1d\u8bd5\u4f7f\u7528\u5176\u4ed6\u7684\u5207\u5206\u4e3b\u952e\u6216\u8005\u8054\u7cfb DBA \u8fdb\u884c\u5904\u7406.");
        }
    }

    private static Pair<Object, Object> checkSplitPk(Connection conn, String pkRangeSQL, int fetchSize, String table, String username, Configuration configuration) {
        ImmutablePair minMaxPK;
        block15: {
            LOG.info("split pk [sql={}] is running... ", (Object)pkRangeSQL);
            ResultSet rs = null;
            minMaxPK = null;
            try {
                try {
                    rs = DBUtil.query(conn, pkRangeSQL, fetchSize);
                }
                catch (Exception e) {
                    throw RdbmsException.asQueryException(DATABASE_TYPE, e, pkRangeSQL, table, username);
                }
                ResultSetMetaData rsMetaData = rs.getMetaData();
                if (SingleTableSplitUtil.isPKTypeValid(rsMetaData)) {
                    if (SingleTableSplitUtil.isStringType(rsMetaData.getColumnType(1))) {
                        if (configuration != null) {
                            configuration.set("pkType", Constant.PK_TYPE_STRING);
                        }
                        while (DBUtil.asyncResultSetNext(rs)) {
                            minMaxPK = new ImmutablePair((Object)rs.getString(1), (Object)rs.getString(2));
                        }
                        break block15;
                    }
                    if (SingleTableSplitUtil.isLongType(rsMetaData.getColumnType(1))) {
                        if (configuration != null) {
                            configuration.set("pkType", Constant.PK_TYPE_LONG);
                        }
                        while (DBUtil.asyncResultSetNext(rs)) {
                            minMaxPK = new ImmutablePair((Object)rs.getString(1), (Object)rs.getString(2));
                            String minMax = rs.getString(1) + rs.getString(2);
                            if (!StringUtils.contains((CharSequence)minMax, (int)46)) continue;
                            throw DataXException.asDataXException((ErrorCode)DBUtilErrorCode.ILLEGAL_SPLIT_PK, "\u60a8\u914d\u7f6e\u7684DataX\u5207\u5206\u4e3b\u952e(splitPk)\u6709\u8bef. \u56e0\u4e3a\u60a8\u914d\u7f6e\u7684\u5207\u5206\u4e3b\u952e(splitPk) \u7c7b\u578b DataX \u4e0d\u652f\u6301. DataX \u4ec5\u652f\u6301\u5207\u5206\u4e3b\u952e\u4e3a\u4e00\u4e2a,\u5e76\u4e14\u7c7b\u578b\u4e3a\u6574\u6570\u6216\u8005\u5b57\u7b26\u4e32\u7c7b\u578b. \u8bf7\u5c1d\u8bd5\u4f7f\u7528\u5176\u4ed6\u7684\u5207\u5206\u4e3b\u952e\u6216\u8005\u8054\u7cfb DBA \u8fdb\u884c\u5904\u7406.");
                        }
                        break block15;
                    }
                    throw DataXException.asDataXException((ErrorCode)DBUtilErrorCode.ILLEGAL_SPLIT_PK, "\u60a8\u914d\u7f6e\u7684DataX\u5207\u5206\u4e3b\u952e(splitPk)\u6709\u8bef. \u56e0\u4e3a\u60a8\u914d\u7f6e\u7684\u5207\u5206\u4e3b\u952e(splitPk) \u7c7b\u578b DataX \u4e0d\u652f\u6301. DataX \u4ec5\u652f\u6301\u5207\u5206\u4e3b\u952e\u4e3a\u4e00\u4e2a,\u5e76\u4e14\u7c7b\u578b\u4e3a\u6574\u6570\u6216\u8005\u5b57\u7b26\u4e32\u7c7b\u578b. \u8bf7\u5c1d\u8bd5\u4f7f\u7528\u5176\u4ed6\u7684\u5207\u5206\u4e3b\u952e\u6216\u8005\u8054\u7cfb DBA \u8fdb\u884c\u5904\u7406.");
                }
                throw DataXException.asDataXException((ErrorCode)DBUtilErrorCode.ILLEGAL_SPLIT_PK, "\u60a8\u914d\u7f6e\u7684DataX\u5207\u5206\u4e3b\u952e(splitPk)\u6709\u8bef. \u56e0\u4e3a\u60a8\u914d\u7f6e\u7684\u5207\u5206\u4e3b\u952e(splitPk) \u7c7b\u578b DataX \u4e0d\u652f\u6301. DataX \u4ec5\u652f\u6301\u5207\u5206\u4e3b\u952e\u4e3a\u4e00\u4e2a,\u5e76\u4e14\u7c7b\u578b\u4e3a\u6574\u6570\u6216\u8005\u5b57\u7b26\u4e32\u7c7b\u578b. \u8bf7\u5c1d\u8bd5\u4f7f\u7528\u5176\u4ed6\u7684\u5207\u5206\u4e3b\u952e\u6216\u8005\u8054\u7cfb DBA \u8fdb\u884c\u5904\u7406.");
            }
            catch (DataXException e) {
                throw e;
            }
            catch (Exception e) {
                throw DataXException.asDataXException(DBUtilErrorCode.ILLEGAL_SPLIT_PK, "DataX\u5c1d\u8bd5\u5207\u5206\u8868\u53d1\u751f\u9519\u8bef. \u8bf7\u68c0\u67e5\u60a8\u7684\u914d\u7f6e\u5e76\u4f5c\u51fa\u4fee\u6539.", e);
            }
            finally {
                DBUtil.closeDBResources(rs, null, null);
            }
        }
        return minMaxPK;
    }

    private static boolean isPKTypeValid(ResultSetMetaData rsMetaData) {
        boolean ret = false;
        try {
            int minType = rsMetaData.getColumnType(1);
            int maxType = rsMetaData.getColumnType(2);
            boolean isNumberType = SingleTableSplitUtil.isLongType(minType);
            boolean isStringType = SingleTableSplitUtil.isStringType(minType);
            if (minType == maxType && (isNumberType || isStringType)) {
                ret = true;
            }
        }
        catch (Exception e) {
            throw DataXException.asDataXException((ErrorCode)DBUtilErrorCode.ILLEGAL_SPLIT_PK, "DataX\u83b7\u53d6\u5207\u5206\u4e3b\u952e(splitPk)\u5b57\u6bb5\u7c7b\u578b\u5931\u8d25. \u8be5\u9519\u8bef\u901a\u5e38\u662f\u7cfb\u7edf\u5e95\u5c42\u5f02\u5e38\u5bfc\u81f4. \u8bf7\u8054\u7cfb\u65fa\u65fa:askdatax\u6216\u8005DBA\u5904\u7406.");
        }
        return ret;
    }

    private static boolean isLongType(int type) {
        boolean isValidLongType = type == -5 || type == 4 || type == 5 || type == -6;
        switch (DATABASE_TYPE) {
            case Oracle: {
                isValidLongType |= type == 2;
                break;
            }
        }
        return isValidLongType;
    }

    private static boolean isStringType(int type) {
        return type == 1 || type == -15 || type == 12 || type == -1 || type == -9;
    }

    private static String genPKRangeSQL(Configuration configuration) {
        String splitPK = configuration.getString("splitPk").trim();
        String table = configuration.getString("table").trim();
        String where = configuration.getString("where", null);
        return SingleTableSplitUtil.genPKSql(splitPK, table, where);
    }

    public static String genPKSql(String splitPK, String table, String where) {
        String minMaxTemplate = "SELECT MIN(%s),MAX(%s) FROM %s";
        String pkRangeSQL = String.format(minMaxTemplate, splitPK, splitPK, table);
        if (StringUtils.isNotBlank((CharSequence)where)) {
            pkRangeSQL = String.format("%s WHERE (%s AND %s IS NOT NULL)", pkRangeSQL, where, splitPK);
        }
        return pkRangeSQL;
    }

    public static List<String> genSplitSqlForOracle(String splitPK, String table, String where, Configuration configuration, int adviceNum) {
        if (adviceNum < 1) {
            throw new IllegalArgumentException(String.format("\u5207\u5206\u4efd\u6570\u4e0d\u80fd\u5c0f\u4e8e1. \u6b64\u5904:adviceNum=[%s].", adviceNum));
        }
        if (adviceNum == 1) {
            return null;
        }
        String whereSql = String.format("%s IS NOT NULL", splitPK);
        whereSql = StringUtils.isNotBlank((CharSequence)where) ? String.format(" WHERE (%s) AND (%s) ", whereSql, where) : String.format(" WHERE (%s) ", whereSql);
        Double percentage = configuration.getDouble("samplePercentage", 0.1);
        String sampleSqlTemplate = "SELECT * FROM ( SELECT %s FROM %s SAMPLE (%s) %s ORDER BY DBMS_RANDOM.VALUE) WHERE ROWNUM <= %s ORDER by %s ASC";
        String splitSql = String.format(sampleSqlTemplate, splitPK, table, percentage, whereSql, adviceNum, splitPK);
        int fetchSize = configuration.getInt("fetchSize", 32);
        String jdbcURL = configuration.getString("jdbcUrl");
        String username = configuration.getString("username");
        String password = configuration.getString("password");
        Connection conn = DBUtil.getConnection(DATABASE_TYPE, jdbcURL, username, password);
        LOG.info("split pk [sql={}] is running... ", (Object)splitSql);
        ResultSet rs = null;
        ArrayList<ImmutablePair> splitedRange = new ArrayList<ImmutablePair>();
        try {
            try {
                rs = DBUtil.query(conn, splitSql, fetchSize);
            }
            catch (Exception e) {
                throw RdbmsException.asQueryException(DATABASE_TYPE, e, splitSql, table, username);
            }
            if (configuration != null) {
                configuration.set("pkType", Constant.PK_TYPE_MONTECARLO);
            }
            ResultSetMetaData rsMetaData = rs.getMetaData();
            while (DBUtil.asyncResultSetNext(rs)) {
                ImmutablePair eachPoint = new ImmutablePair(rs.getObject(1), (Object)rsMetaData.getColumnType(1));
                splitedRange.add(eachPoint);
            }
        }
        catch (DataXException e) {
            throw e;
        }
        catch (Exception e) {
            throw DataXException.asDataXException(DBUtilErrorCode.ILLEGAL_SPLIT_PK, "DataX\u5c1d\u8bd5\u5207\u5206\u8868\u53d1\u751f\u9519\u8bef. \u8bf7\u68c0\u67e5\u60a8\u7684\u914d\u7f6e\u5e76\u4f5c\u51fa\u4fee\u6539.", e);
        }
        finally {
            DBUtil.closeDBResources(rs, null, null);
        }
        LOG.debug(JSON.toJSONString(splitedRange));
        ArrayList<String> rangeSql = new ArrayList<String>();
        int splitedRangeSize = splitedRange.size();
        if (splitedRangeSize >= 2) {
            if (SingleTableSplitUtil.isLongType((Integer)((Pair)splitedRange.get(0)).getRight())) {
                BigInteger[] integerPoints = new BigInteger[splitedRange.size()];
                for (int i = 0; i < splitedRangeSize; ++i) {
                    integerPoints[i] = new BigInteger(((Pair)splitedRange.get(i)).getLeft().toString());
                }
                rangeSql.addAll(RdbmsRangeSplitWrap.wrapRange(integerPoints, splitPK));
                rangeSql.add(RdbmsRangeSplitWrap.wrapFirstLastPoint(integerPoints[0], integerPoints[splitedRangeSize - 1], splitPK));
            } else if (SingleTableSplitUtil.isStringType((Integer)((Pair)splitedRange.get(0)).getRight())) {
                String[] stringPoints = new String[splitedRange.size()];
                for (int i = 0; i < splitedRangeSize; ++i) {
                    stringPoints[i] = new String(((Pair)splitedRange.get(i)).getLeft().toString());
                }
                rangeSql.addAll(RdbmsRangeSplitWrap.wrapRange(stringPoints, splitPK, "'", DATABASE_TYPE));
                rangeSql.add(RdbmsRangeSplitWrap.wrapFirstLastPoint(stringPoints[0], stringPoints[splitedRangeSize - 1], splitPK, "'", DATABASE_TYPE));
            } else {
                throw DataXException.asDataXException((ErrorCode)DBUtilErrorCode.ILLEGAL_SPLIT_PK, "\u60a8\u914d\u7f6e\u7684DataX\u5207\u5206\u4e3b\u952e(splitPk)\u6709\u8bef. \u56e0\u4e3a\u60a8\u914d\u7f6e\u7684\u5207\u5206\u4e3b\u952e(splitPk) \u7c7b\u578b DataX \u4e0d\u652f\u6301. DataX \u4ec5\u652f\u6301\u5207\u5206\u4e3b\u952e\u4e3a\u4e00\u4e2a,\u5e76\u4e14\u7c7b\u578b\u4e3a\u6574\u6570\u6216\u8005\u5b57\u7b26\u4e32\u7c7b\u578b. \u8bf7\u5c1d\u8bd5\u4f7f\u7528\u5176\u4ed6\u7684\u5207\u5206\u4e3b\u952e\u6216\u8005\u8054\u7cfb DBA \u8fdb\u884c\u5904\u7406.");
            }
        }
        return rangeSql;
    }
}

