package org.bdware.server.action;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import org.bdware.sc.conn.ByteUtil;
import org.bdware.sc.conn.ResultCallback;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;

import static io.netty.handler.codec.http.HttpResponseStatus.OK;

public class HttpResultCallback extends ResultCallback implements Runnable {
    protected ChannelHandlerContext ctxField;
    String jsonCallback;
    Map<String, String> extraHeaders = new HashMap<>();
    DefaultFullHttpResponse response;
    byte[] bytes;
    private boolean decodeAsB64 = false;

    public HttpResultCallback(ChannelHandlerContext ctx, String jsonCallback) {
        ctxField = ctx;
        this.jsonCallback = jsonCallback;
    }

    @Override
    public void onResult(String ret) {
        if (jsonCallback != null) {
            ret = (jsonCallback + "(" + ret + ")");
        }
        if (ret != null && !ctxField.isRemoved()) {
            bytes = null;
            if (decodeAsB64)
                try {
                    bytes = ByteUtil.decodeBASE64(ret);
                } catch (Exception e) {
                    ByteArrayOutputStream bo = new ByteArrayOutputStream();
                    e.printStackTrace(new PrintStream(bo));
                    bytes = bo.toByteArray();
                }
            else {
                bytes = ret.getBytes();
            }
            assert bytes != null;
            response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, OK,
                    Unpooled.wrappedBuffer(bytes));

            for (String key : extraHeaders.keySet())
                response.headers().add(key, extraHeaders.get(key));
            ctxField.channel().eventLoop().execute(this);
        } // Just ignore

    }

    public HttpResultCallback addHeader(String key, String val) {
        extraHeaders.put(key, val);
        return this;
    }

    @Override
    public void run() {
        HttpUtil.setContentLength(response, bytes.length);
        ChannelFuture future = ctxField.writeAndFlush(response);
        future.addListener(ChannelFutureListener.CLOSE);
    }

    public void setDecodeBase64() {
        decodeAsB64 = true;
    }
}
