package org.bdware.server.action;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.*;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class HttpServerSentEventResultCallback extends HttpResultCallback implements Closeable {
    public static ScheduledExecutorService scheduledThreadPool =
            Executors.newScheduledThreadPool(1);
    private ScheduledFuture<?> currentScheduler;
    private long lastUpdate;

    public HttpServerSentEventResultCallback(ChannelHandlerContext ctx, String jsonCallback) {
        super(ctx, jsonCallback);
        ctxField = ctx;

    }

    public void writeInitialHead() {
        HttpResponse response =
                new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        for (String key : extraHeaders.keySet())
            response.headers().add(key, extraHeaders.get(key));
        ctxField.writeAndFlush(response);
        currentScheduler = scheduledThreadPool.schedule(this, 10, TimeUnit.SECONDS);
        final ByteBuf buffer = Unpooled.copiedBuffer("\n", StandardCharsets.UTF_8);
        ctxField.writeAndFlush(new DefaultHttpContent(buffer));
    }

    boolean closed = false;

    @Override
    public void onResult(String ret) {
        ByteBuf event = Unpooled.copiedBuffer("event: onResult\n", StandardCharsets.UTF_8);
        ctxField.writeAndFlush(new DefaultHttpContent(event));
        ByteBuf buffer = Unpooled.copiedBuffer("data: " + ret + "\n\n", StandardCharsets.UTF_8);
        ctxField.writeAndFlush(new DefaultHttpContent(buffer));
        lastUpdate = System.currentTimeMillis();
        if (ret.contains("\"onDistributeFinish\"")) {
            lastUpdate = 0;
            currentScheduler.cancel(true);
            try {
                close();
            } catch (Exception e) {
            }
        }
    }

    static Logger LOGGER = LogManager.getLogger(HttpServerSentEventResultCallback.class);

    @Override
    public void run() {
        try {
            if (System.currentTimeMillis() - lastUpdate < 10000L) {
                // reschedule
                LOGGER.info("Reschedule time out");
                currentScheduler = scheduledThreadPool.schedule(this, 10, TimeUnit.SECONDS);
                return;
            }
            if (!closed) {
                final ByteBuf buffer = Unpooled.copiedBuffer(
                        "{\"action\":\"onDistributeFinish\",\"progress\":\"-1\",\"data\":\"timeout\"}"
                                + "\n\n",
                        StandardCharsets.UTF_8);
                ctxField.writeAndFlush(new DefaultHttpContent(buffer));
            }
            close();
        } catch (IOException e) {

        }
    }

    @Override
    public synchronized void close() throws IOException {
        closed = true;
        ctxField.close();
    }
}
