package org.bdware.server.action;

import com.google.gson.JsonObject;
import org.bdware.sc.conn.ResultCallback;
import org.bdware.sc.index.LenVarTimeSerialIndex2;
import org.bdware.sc.util.HashUtil;
import org.bdware.sc.util.JsonUtil;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IndexAction {

    static final String MISSING_ARGUMENT = "{\"status\":\"Errorr\",\"data\":\"missing arguments\"}";
    static Map<String, LenVarTimeSerialIndex2> fileMap = new HashMap<>();

    public IndexAction() {}

    @Action(async = true)
    public void createFile(JsonObject args, final ResultCallback resultCallback) {
        if (!args.has("file")) {
            resultCallback.onResult(MISSING_ARGUMENT);
            return;
        }
        if (!args.has("dataLength")) {
            resultCallback.onResult(MISSING_ARGUMENT);
            return;
        }
        try {
            String fileName = "./" + args.get("file").getAsString();
            File f = new File(fileName + ".datasize");
            FileOutputStream fout = new FileOutputStream(f);
            int dataLength = args.get("dataLength").getAsInt();
            for (int i = 0; i < dataLength; i++)
                fout.write(1);
            fout.close();
            // LenVarTimeSerialIndex2 index = getIndexFile(fileName);
            resultCallback.onResult("{\"status\":\"Success\",\"dataLength\":" + dataLength
                    + ",\".datasize\":" + f.length() + "}");

        } catch (Exception e) {
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream(bo));
            resultCallback.onResult(bo.toString());
        }
    }

    @Action(async = true)
    public void index(JsonObject args, final ResultCallback resultCallback) {
        if (!args.has("content")) {
            resultCallback.onResult(MISSING_ARGUMENT);
            return;
        }
        if (!args.has("file")) {
            resultCallback.onResult(MISSING_ARGUMENT);
            return;
        }

        try {
            LenVarTimeSerialIndex2 index = getIndexFile(args.get("file").getAsString());
            String content = args.get("content").getAsString();
            long ret = index.index(HashUtil.str16ToBytes(content));
            resultCallback.onResult("{\"status\":\"Success\",\"date\":" + ret + "}");

        } catch (Exception e) {
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream(bo));
            resultCallback.onResult(bo.toString());
        }
    }

    @Action(async = true)
    public void dataSize(JsonObject args, final ResultCallback resultCallback) {
        if (!args.has("file")) {
            resultCallback.onResult(MISSING_ARGUMENT);
            return;
        }
        try {
            LenVarTimeSerialIndex2 index = getIndexFile(args.get("file").getAsString());

            resultCallback.onResult(
                    "{\"dataSize\":" + index.dataSize + ",\"fileSize\":" + index.fileSize + "}");

        } catch (Exception e) {
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream(bo));
            resultCallback.onResult(bo.toString());
        }
    }

    @Action(async = true)
    public void requestByTime(JsonObject args, final ResultCallback resultCallback) {
        if (!args.has("file")) {
            resultCallback.onResult(MISSING_ARGUMENT);
            return;
        }
        if (!args.has("startTime")) {
            resultCallback.onResult(MISSING_ARGUMENT);
            return;
        }
        if (!args.has("endTime")) {
            resultCallback.onResult(MISSING_ARGUMENT);
            return;
        }
        try {
            LenVarTimeSerialIndex2 index = getIndexFile(args.get("file").getAsString());
            long startTime = args.get("startTime").getAsLong();
            long endTime = args.get("endTime").getAsLong();
            List<byte[]> result = index.requestByTime(startTime, endTime);
            returnSuccess(resultCallback, result);
        } catch (Exception e) {
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream(bo));
            resultCallback.onResult(bo.toString());
        }
    }

    private void returnSuccess(ResultCallback resultCallback, List<byte[]> result) {
        Response r = new Response();
        r.status = "Success";
        r.list = new ArrayList<>();
        for (byte[] bytes : result) {
            r.list.add(new Data(bytes));
        }
        resultCallback.onResult(JsonUtil.toJson(r));
    }

    @Action(async = true)
    public void request(JsonObject args, final ResultCallback resultCallback) {
        if (!args.has("file")) {
            resultCallback.onResult(MISSING_ARGUMENT);
            return;
        }
        if (!args.has("offset")) {
            resultCallback.onResult(MISSING_ARGUMENT);
            return;
        }
        if (!args.has("count")) {
            resultCallback.onResult(MISSING_ARGUMENT);
            return;
        }
        try {
            LenVarTimeSerialIndex2 index = getIndexFile(args.get("file").getAsString());
            long offset = args.get("offset").getAsLong();
            int count = args.get("count").getAsInt();
            List<byte[]> result = index.request(offset, count);

            returnSuccess(resultCallback, result);
        } catch (Exception e) {
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream(bo));
            resultCallback.onResult(bo.toString());
        }
    }

    @Action(async = true)
    public void getSize(JsonObject args, final ResultCallback resultCallback) {
        if (!args.has("file")) {
            resultCallback.onResult(MISSING_ARGUMENT);
            return;
        }
        try {
            LenVarTimeSerialIndex2 index = getIndexFile(args.get("file").getAsString());
            int size = (int) index.size();
            resultCallback.onResult("{\"status\":\"Success\",\"size\":" + size + "}");
        } catch (Exception e) {
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream(bo));
            resultCallback.onResult(bo.toString());
        }
    }

    private LenVarTimeSerialIndex2 getIndexFile(String str) {
        LenVarTimeSerialIndex2 indexFile = fileMap.get(str);
        if (indexFile == null) {
            indexFile = new LenVarTimeSerialIndex2(str);
            fileMap.put(str, indexFile);
        }
        return indexFile;
    }

    @Action(async = true)
    public void manullyIndex(JsonObject args, final ResultCallback resultCallback) {
        if (!args.has("date")) {
            resultCallback.onResult(MISSING_ARGUMENT);
            return;
        }
        if (!args.has("content")) {
            resultCallback.onResult(MISSING_ARGUMENT);
            return;
        }
        if (!args.has("file")) {
            resultCallback.onResult(MISSING_ARGUMENT);
            return;
        }
        try {
            LenVarTimeSerialIndex2 index = getIndexFile(args.get("file").getAsString());
            long date = Long.parseLong(args.get("date").getAsString());
            String content = args.get("content").getAsString();
            index.manullyIndex(date, HashUtil.str16ToBytes(content));
            resultCallback.onResult("{\"status\":\"Success\"}");

        } catch (Exception e) {
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream(bo));
            resultCallback.onResult(bo.toString());
        }
    }

    static class Response {
        String status;
        List<Data> list;
    }

    static class Data {
        long date;
        String data;

        public Data(byte[] bytes) {
            date = HashUtil.bytes2Long(bytes);
            data = HashUtil.byteArray2Str(bytes, 8);
        }
    }
}
