package org.bdware.server.action;

import com.google.gson.JsonObject;
import org.bdware.sc.conn.ResultCallback;
import org.bdware.server.nodecenter.Response;

import java.util.HashMap;
import java.util.Map;

public class ReplyUtil {
    public static void simpleReply(ResultCallback resultCallback, String action, Object data) {
        Map<String, Object> ret = new HashMap<>();
        ret.put("action", action);
        ret.put("data", data);
        resultCallback.onResult(ret);
    }

    public static void replyWithStatus(ResultCallback resultCallback, String action, boolean status,
            Object data) {
        Map<String, Object> ret = new HashMap<>();
        ret.put("action", action);
        ret.put("status", status);
        ret.put("data", data);
        resultCallback.onResult(ret);
    }

    public static void injectRequestID(Response response, JsonObject json) {
        if (json.has("requestID"))
            response.responseID = json.get("requestID").getAsString();
    }
}
