package org.bdware.server.permission;

public enum Permission {
    // GetSessionID(0), GetRole(0), Login(0), // 默认权限设置为0
    // ApplyRole(1 << 0), // 匿名用户申请成为节点管理员（NodePortal）角色
    // NodeStateList(1 << 1), // 中心节点查看节点管理员的所管理所有节点的状态
    // AuthNodeManager(1 << 2), // 授权节点管理员
    // DeleteNodeManager(1 << 3), // 从网络中删除某个节点管理员
    // ListAllUsers(1 << 4), // ListAllUser
    // ListApplyUser(1 << 5), // ListApplyUser
    // ListTrustCluster(1 << 6), // 查看可信执行集群列表
    // AssignTrustedCluster(1 << 7), // 分配可信执行集群
    //
    // // ==================NodePotral===============
    // //ApplyNodeRole(1<<6),//申请节点角色
    // AuthNodeRole(1 << 8), // 授权角色
    // DeleteRole(1 << 9), // 从用户角色中删除某一种角色
    // ListAllAuthUsers(1 << 10), // 查看已授权用户
    // ListUnAuthUsers(1 << 11), // 查看未授权用户
    //
    // StartContract(1 << 12), ExecuteContract(1 << 13), StopContract(1 << 14), // stop和kill一样
    // UploadContract(1 << 15), // 上传合约代码（修改代码、更新合约代码、保存代码)
    // DownloadContract(1 << 16), // 下载合约代码
    // DeleteContract(1 << 17), // 删除合约代码
    //
    // ContractCodeStatisticsList(1 << 18), // 查看合约代码统计数据（合约文件大小)
    // StaticAnalysis(1 << 19), // 静态分析
    // ConfigureContractPermission(1 << 20), // 配置合约权限
    // ContractProgressList(1L << 22L), // 查看合约进程(listContractProcess)
    //
    // QueryActionLog(1L << 24L), // 增加listLog(时间戳)
    // QueryUserStateLog(1L << 25L), // 查看节点日志
    // ListLocalNodeStatus(1L << 26L), // 节点状态(此节点)
    // ListContractLog(1L << 27L), // 合约日志
    //
    // TimeTravel(1L << 28L), ManualDump(1L << 29L), // 手动dump
    // ForkContractStatus(1L << 30L), // 合约状态从别处迁移到自己本地
    // ConfigureNode(1L << 31L), // 配置节点信息
    // listProjects(1L << 32L),// 合约提供者


    // 新加的一些权限
    // listLicence(1L<<33L)//证书列表 updateLicence权限也写成这个了，有没有必要分开

    // TODO: 20205/20 需要整理权限就权限和最新的权限

    // CenterManager (其他部分代码中出现的，暂未合并整理)
    ApplyRole(1 << 0), NodeStateList(1 << 1), AuthNodeManager(1 << 2), ListAllUsers(
            1 << 3), ListApplyUser(1 << 4), DeleteNodeManager(1 << 5), ListTrustCluster(
                    1 << 6), AssignTrustedCluster(
                            1 << 7), QueryActionLog(1 << 8), QueryUserStateLog(1 << 9),

    // Node
    ConfigureNode(1 << 10), // 其他地方代码中的权限
    ManageNode(1 << 10), // 节点管理
    GetNodeInfo(1 << 11), // 节点信息获取

    ContractCodeStatisticsList(1 << 12), // 其他地方代码中的权限
    ConfigureContractPermission(1 << 13), // 其他地方代码中的权限
    EditContract(1 << 14), // 编辑合约
    ListProject(1L << 15), // 查看project信息
    StaticAnalysis(1L << 16), // 静态分析
    Compile(1L << 17), // 编译相关及其他权限类似操作

    ContractPermissionList(1L << 18), // 查看合约权限
    ListContractProgress(1L << 19), // 合约进程列表
    CheckContractStatus(1L << 20), // 查看合约状态（被调用多少次，占用内存等等)
    TimeTravel(1L << 21), // 其他地方代码中的权限
    ListContractLog(1L << 22), // 查看合约日志
    ManageMemory(1L << 23), // 内存管理
    CreateLedger(1L << 24), // ledger相关

    ManualDump(1L << 25), // 手动dump
    ManageContract(1L << 26), // 更改合约运行状态

    TakeScreenShot(1L << 27);

    public final long value;

    Permission(long value) {
        this.value = value;
    }

    public long getValue() {
        return value;
    }
}
