package org.bdware.server.permission;

public enum Role {
    CenterManager(0x3ffL), NodeManager(0xe41L), Node(0x1L), ContractProvider(
            0x3f000L), ContractInstanceManager(0x7ff10c0L), ContractUser(0x5c0000L), Anonymous(0);

    long value;

    Role(long v) {
        value = v;
    };

    public static Role parse(String str) {
        try {
            return valueOf(str);
        } catch (Exception e) {
            return Anonymous;
        }
    }

    public long getValue() {
        return value;
    }

    public static long compoundValue(String[] roles) {
        long ret = 0;
        if (roles != null) {
            for (String role : roles) {
                ret |= parse(role).value;
            }
        }
        return ret;
    }

    public String getString(Role role) {
        return role.toString();
    }
}
