/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.server.action;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import org.bdware.sc.conn.ByteUtil;
import org.bdware.sc.conn.ResultCallback;

public class HttpResultCallback
extends ResultCallback
implements Runnable {
    protected ChannelHandlerContext ctxField;
    String jsonCallback;
    Map<String, String> extraHeaders = new HashMap<String, String>();
    DefaultFullHttpResponse response;
    byte[] bytes;
    private boolean decodeAsB64 = false;

    public HttpResultCallback(ChannelHandlerContext ctx, String jsonCallback) {
        this.ctxField = ctx;
        this.jsonCallback = jsonCallback;
    }

    public void onResult(String ret) {
        if (this.jsonCallback != null) {
            ret = this.jsonCallback + "(" + ret + ")";
        }
        if (ret != null && !this.ctxField.isRemoved()) {
            this.bytes = null;
            if (this.decodeAsB64) {
                try {
                    this.bytes = ByteUtil.decodeBASE64((String)ret);
                }
                catch (Exception e) {
                    ByteArrayOutputStream bo = new ByteArrayOutputStream();
                    e.printStackTrace(new PrintStream(bo));
                    this.bytes = bo.toByteArray();
                }
            } else {
                this.bytes = ret.getBytes();
            }
            assert (this.bytes != null);
            this.response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.wrappedBuffer((byte[])this.bytes));
            for (String key : this.extraHeaders.keySet()) {
                this.response.headers().add(key, (Object)this.extraHeaders.get(key));
            }
            this.ctxField.channel().eventLoop().execute((Runnable)this);
        }
    }

    public HttpResultCallback addHeader(String key, String val) {
        this.extraHeaders.put(key, val);
        return this;
    }

    @Override
    public void run() {
        HttpUtil.setContentLength((HttpMessage)this.response, (long)this.bytes.length);
        ChannelFuture future = this.ctxField.writeAndFlush((Object)this.response);
        future.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    public void setDecodeBase64() {
        this.decodeAsB64 = true;
    }
}

