/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.server.action;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.server.action.HttpResultCallback;

public class HttpServerSentEventResultCallback
extends HttpResultCallback
implements Closeable {
    public static ScheduledExecutorService scheduledThreadPool = Executors.newScheduledThreadPool(1);
    private ScheduledFuture<?> currentScheduler;
    private long lastUpdate;
    boolean closed = false;
    static Logger LOGGER = LogManager.getLogger(HttpServerSentEventResultCallback.class);

    public HttpServerSentEventResultCallback(ChannelHandlerContext ctx, String jsonCallback) {
        super(ctx, jsonCallback);
        this.ctxField = ctx;
    }

    public void writeInitialHead() {
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        for (String key : this.extraHeaders.keySet()) {
            response.headers().add(key, this.extraHeaders.get(key));
        }
        this.ctxField.writeAndFlush((Object)response);
        this.currentScheduler = scheduledThreadPool.schedule(this, 10L, TimeUnit.SECONDS);
        ByteBuf buffer = Unpooled.copiedBuffer((CharSequence)"\n", (Charset)StandardCharsets.UTF_8);
        this.ctxField.writeAndFlush((Object)new DefaultHttpContent(buffer));
    }

    @Override
    public void onResult(String ret) {
        ByteBuf event = Unpooled.copiedBuffer((CharSequence)"event: onResult\n", (Charset)StandardCharsets.UTF_8);
        this.ctxField.writeAndFlush((Object)new DefaultHttpContent(event));
        ByteBuf buffer = Unpooled.copiedBuffer((CharSequence)("data: " + ret + "\n\n"), (Charset)StandardCharsets.UTF_8);
        this.ctxField.writeAndFlush((Object)new DefaultHttpContent(buffer));
        this.lastUpdate = System.currentTimeMillis();
        if (ret.contains("\"onDistributeFinish\"")) {
            this.lastUpdate = 0L;
            this.currentScheduler.cancel(true);
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void run() {
        try {
            if (System.currentTimeMillis() - this.lastUpdate < 10000L) {
                LOGGER.info("Reschedule time out");
                this.currentScheduler = scheduledThreadPool.schedule(this, 10L, TimeUnit.SECONDS);
                return;
            }
            if (!this.closed) {
                ByteBuf buffer = Unpooled.copiedBuffer((CharSequence)"{\"action\":\"onDistributeFinish\",\"progress\":\"-1\",\"data\":\"timeout\"}\n\n", (Charset)StandardCharsets.UTF_8);
                this.ctxField.writeAndFlush((Object)new DefaultHttpContent(buffer));
            }
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public synchronized void close() throws IOException {
        this.closed = true;
        this.ctxField.close();
    }
}

