/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.server.permission;

public enum Role {
    CenterManager(1023L),
    NodeManager(3649L),
    Node(1L),
    ContractProvider(258048L),
    ContractInstanceManager(134156480L),
    ContractUser(0x5C0000L),
    Anonymous(0L);

    long value;

    private Role(long v) {
        this.value = v;
    }

    public static Role parse(String str) {
        try {
            return Role.valueOf(str);
        }
        catch (Exception e) {
            return Anonymous;
        }
    }

    public long getValue() {
        return this.value;
    }

    public static long compoundValue(String[] roles) {
        long ret = 0L;
        if (roles != null) {
            for (String role : roles) {
                ret |= Role.parse((String)role).value;
            }
        }
        return ret;
    }

    public String getString(Role role) {
        return role.toString();
    }
}

