package org.bdware.server.action;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.METHOD)
public @interface Action {
    boolean httpAccess() default true;

    boolean websocketAccess() default true;

    boolean async() default false;

    long userPermission() default 0l;

    String[] alias() default {};
}
