package org.bdware.server.action;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.sc.util.JsonUtil;

import java.io.FileNotFoundException;
import java.io.RandomAccessFile;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;

public class ActionExecutor<T, U> {
    private static final Logger LOGGER = LogManager.getLogger(ActionExecutor.class);
    // ---------- use for profiling
    static Map<String, Map<String, AtomicInteger>> allData = new ConcurrentHashMap<>();
    public ExecutorService executor;
    // private Profiler profiler = new Profiler();
    public long permission;
    Map<String, AtomicInteger> staticData;
    private Map<String, Pair<Method, Object>> handlers;
    private Object Constructor;

    public ActionExecutor(ExecutorService executor, Object... classes) {
        this.executor = executor;
        permission = 0;
        initHandlers(classes);
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        String caller = stackTraceElements[2].getClassName();
        caller += (int) (Math.random() * 10000);
        staticData = new ConcurrentHashMap<>();
        allData.putIfAbsent(caller, staticData);
    }

    public static Set<String> getAECallerSet() {
        return allData.keySet();
    }

    public static Map<String, AtomicInteger> getStatistic(String caller) {
        return allData.get(caller);
    }

    public static Map<String, Map<String, AtomicInteger>> getAllData() {
        return allData;
    }

    @SuppressWarnings("unused")
    public Map<String, AtomicInteger> getStaticData() {
        return staticData;
    }

    // ---------- use for profiling
    private void initHandlers(Object... objects) {
        handlers = new HashMap<>();
        if (objects.length > 0) {
            for (Object obj : objects) {
                appendHandler(obj);
            }
        }
    }

    public boolean checkPermission(Action a, final U args, long permission) {
        return true;
    }

    public Map<String, Pair<Method, Object>> getHandlers() {
        return handlers;
    }

    public void appendHandler(Object obj) {
        try {
            if (null == obj) {
                return;
            }
            Method[] methods = obj.getClass().getDeclaredMethods();
            for (Method method : methods) {
                if (null != method.getAnnotation(Action.class)) {
                    if (method.getAnnotation(Action.class).alias().length == 0) {
                        handlers.put(method.getName(), new Pair<>(method, obj));
                        if (!method.getReturnType().equals(Void.TYPE)
                                || method.getParameterCount() != 2) {
                            LOGGER.error("action ret is not void:"
                                    + obj.getClass().getCanonicalName() + "-->" + method.getName());

                            System.exit(0);
                        }
                    } else {
                        for (String a : method.getAnnotation(Action.class).alias()) {
                            handlers.put(a, new Pair<>(method, obj));
                            if (!method.getReturnType().equals(Void.TYPE)
                                    || method.getParameterCount() != 2) {
                                LOGGER.error("action ret is not void:"
                                        + obj.getClass().getCanonicalName() + "-->"
                                        + method.getName());

                                System.exit(0);
                            }
                        }
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void handle(String action, final U args, final T callback)
            throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        // LOGGER.info("handling " + action + "...");
        // LOGGER.info("handle : " + action + " ->" + JsonUtil.toJson(args));

        if (null != action) {
            if (staticData.containsKey(action)) {
                staticData.get(action).incrementAndGet();
            } else {
                staticData.put(action, new AtomicInteger(1));
            }
        }
        // logger.debug("[ActionExecutor] handle : ");
        if (!handlers.containsKey(action)) {
            LOGGER.debug("unsupported action " + action + "->" + JsonUtil.toJson(args));
            throw new IllegalArgumentException("unsupported action " + action);
        }

        final Pair<Method, Object> pair = handlers.get(action);
        Action actionAnnotations = pair.first.getAnnotation(Action.class);
        if (!checkPermission(actionAnnotations, args, permission)) {
            LOGGER.info("unauthorised action " + action + " -> " + JsonUtil.toJson(args));
            throw new IllegalArgumentException("unauthorised action " + action);
        }

        if (actionAnnotations.async()) {
            executor.execute(() -> {
                try {
                    pair.first.invoke(pair.second, args, callback);
                } catch (Exception e) {
                    LOGGER.debug(pair.first.getDeclaringClass().getCanonicalName() + "->"
                            + pair.first.getName());
                    e.printStackTrace();
                }
            });
        } else {
            pair.first.invoke(pair.second, args, callback);
        }
    }

    @SuppressWarnings("unused")
    static class Profiler {
        RandomAccessFile log;

        Profiler() {
            try {
                log = new RandomAccessFile("./log/profile.log", "rw");
            } catch (FileNotFoundException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
        }
    }

    public static class Pair<T, U> {
        T first;
        U second;

        public Pair(T f, U s) {
            first = f;
            second = s;
        }

        public T first() {
            return first;
        }
    }
}
