package org.bdware.server.action;

import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.sc.ContractResult;
import org.bdware.sc.ContractResult.Status;
import org.bdware.sc.conn.InstrumentedResultCallback;
import org.bdware.sc.conn.ResultCallback;
import org.bdware.sc.util.JsonUtil;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class SyncResult {
    public static final HashedWheelTimer timer =
            new HashedWheelTimer(Executors.defaultThreadFactory(), 5, TimeUnit.MILLISECONDS, 2);
    private static final Logger LOGGER = LogManager.getLogger(SyncResult.class);
    public Map<String, ResultCallback> waitObj = new ConcurrentHashMap<>();

    public synchronized void wakeUp(String requestID, String result) {
        ResultCallback ob = waitObj.get(requestID);
        // TODO 难怪之前这是注释的。
        waitObj.remove(requestID);
        // cancel timeout
        if (ob != null) {
            ob.cancelTimeOut();
            ob.onResult(result);
        }
    }

    public void instrumentWakeUp(String requestID,
            InstrumentedResultCallback instrumentedResultCallback, JsonObject result) {
        ResultCallback ob = waitObj.get(requestID);
        // TODO 难怪之前这是注释的。
        waitObj.remove(requestID);
        // cancel timeout
        if (ob != null) {
            ob.cancelTimeOut();
            instrumentedResultCallback.onResult(ob, result);
        }
    }

    public void sleep(String requestID, ResultCallback cb) {
        // TODO 这里有bug
        sleepWithTimeout(requestID, cb, 20);
    }

    public void sleepWithTimeout(final String requestID, ResultCallback cb, int timeOut) {
        if (!waitObj.containsKey(requestID)) {
            CancelTask tt = new CancelTask(requestID);
            Timeout timeout = timer.newTimeout(tt, timeOut, TimeUnit.SECONDS);
            // logger.debug("reqID:" + requestID + " createTimeout:" + timeout);
            cb.setTimeOut(timeout);
            waitObj.put(requestID, cb);
        } else {
            LOGGER.debug("[Duplicated RequestID]" + requestID);
        }
    }

    public ContractResult syncSleep(String requestID) {
        ContractResultCallback cb = new ContractResultCallback();
        sleep(requestID, cb);

        synchronized (cb) {
            try {
                cb.wait(20000L);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return cb.cr;
    }

    public boolean canIssue() {
        // TODO add flow control
        int waitSize = waitObj.keySet().size();

        return true;
    }

    public static class ContractResultCallback extends ResultCallback {
        ContractResult cr = new ContractResult(Status.Error, new JsonPrimitive("Timeout!!"));
        int reRoute = 0;

        @Override
        public void onResult(String str) {
            cr = JsonUtil.fromJson(str, ContractResult.class);
            synchronized (this) {
                this.notifyAll();
            }
        }

        public int getReRouteCount() {
            return reRoute;
        }

        public void incReRouteCount() {
            reRoute++;
        }
    }

    class CancelTask implements TimerTask {
        String requestID;

        CancelTask(String requestID) {
            this.requestID = requestID;
        }

        public void run(Timeout timeout) {
            ContractResult cr = new ContractResult(Status.Error, new JsonPrimitive("Timeout!"));
            wakeUp(requestID, JsonUtil.toJson(cr));
        }
    }
}
