package org.bdware.server.nodecenter.client;

import com.google.gson.reflect.TypeToken;
import org.bdware.sc.bean.ContractDesp;
import org.bdware.sc.util.JsonUtil;

import java.util.List;
import java.util.Map;

public class CMNodeBean {
    public List<ContractDesp> contracts;
    public String pubKey;
    public String nodeName;
    public String udpID;
    public String ipPort;
    public String cimanager = "";

    public CMNodeBean(String publicKeyStr) {
        pubKey = publicKeyStr;
    }

    // TODO nodeMangerPubkey
    public void updateContract(Map<String, String> json) {
        String jsonStr = json.get("contracts");
        contracts = JsonUtil.fromJson(jsonStr, new TypeToken<List<ContractDesp>>() {}.getType());
        // KeyValueDBUtil.instance.setValue(NCTables.NodesDB.toString(), pubKey,
        // JsonUtil.toJson(this));

    }

    // when the center received an event, publish it to subscriber.

    public String formatContractName(String contractIDOrName) {
        if (null != contracts) {
            for (ContractDesp desp : contracts) {
                if (desp.contractID.equals(contractIDOrName)
                        || desp.contractName.equals(contractIDOrName)) {
                    return desp.contractName;
                }
            }
        }
        return null;
    }

    public boolean containsContract(String contractIDOrName) {
        if (null != contracts) {
            for (ContractDesp desp : contracts) {
                if (desp.contractID.equals(contractIDOrName)
                        || desp.contractName.equals(contractIDOrName))
                    return true;
            }
        }
        return false;
    }

    public boolean containsEvent(String contractIDOrName, String event) {
        if (null != contracts) {
            for (ContractDesp desp : contracts) {
                if (desp.contractID.equals(contractIDOrName)
                        || desp.contractName.equals(contractIDOrName)) {
                    if (desp.events.containsKey(event))
                        return true;
                }
            }
        }
        return false;
    }

    public void removeCIManager(String string) {
        System.out.println("removeCIManager" + string);
        int start = this.cimanager.indexOf(string);
        if (start > 0) {
            this.cimanager = this.cimanager.substring(0, start)
                    .concat(this.cimanager.substring(start + 130));
        }
    }

    public void addCIManager(String string) {
        System.out.println("addCIManager" + string);
        this.cimanager = this.cimanager.concat(" " + string);
    }

    public void setCIManager(String string) {
        this.cimanager = string;

    }

}
