/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.server;

import com.google.gson.JsonArray;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.sc.util.JsonUtil;

public class CMDConf {
    private static final Logger LOGGER = LogManager.getLogger(CMDConf.class);
    public String cmi = "";
    public String debug = "";
    public String repoDoid = "";
    public String lhsAddress = "";
    public String repoName;
    public int doipPort = -1;
    public boolean enableEventPersistence = false;
    public String enableSsl = "./ssl/chained.pem:./ssl/domain.pem";
    public String ip = "127.0.0.1";
    public boolean overwrite = false;
    public int servicePort = 18005;
    public String textFileSuffixes = ".yjs,.json,.txt,.css,.js,.html,.md,.conf,.csv";
    public String withBdledgerClient = "./runnable/bdledger_mac";
    public boolean withBdledgerServer = false;
    public String wsPluginActions = "";
    public String clientToAgentPlugins = "";
    public String clientToClusterPlugins = "";
    public String tcpPlugins = "";
    public String consistencyPlugins = "";
    public JsonArray startContract = null;
    public String datachainConf = null;

    public static CMDConf parseFile(String confPath) {
        CMDConf ret = null;
        File conf = new File(confPath);
        if (conf.exists()) {
            try (BufferedReader br = new BufferedReader(new FileReader(conf));){
                String temp;
                StringBuilder sbl = new StringBuilder();
                while (null != (temp = br.readLine())) {
                    sbl.append(temp);
                }
                ret = (CMDConf)JsonUtil.fromJson((String)sbl.toString(), CMDConf.class);
            }
            catch (IOException ignored) {
                LOGGER.warn("parsing configure from file failed!");
            }
        }
        if (null == ret) {
            LOGGER.warn("use default configure");
            return new CMDConf();
        }
        return ret;
    }

    public CMDConf parseArgs(String[] args) {
        for (String arg : args) {
            if (null == arg || !arg.startsWith("-")) continue;
            String[] cmdArg = arg.split("=");
            String[] cmdArgName = cmdArg[0].substring(1).split("-");
            StringBuilder sbl = new StringBuilder(cmdArgName[0]);
            for (int i = 1; i < cmdArgName.length; ++i) {
                sbl.append(cmdArgName[i].substring(0, 1).toUpperCase()).append(cmdArgName[i].substring(1));
            }
            String fieldName = sbl.toString();
            try {
                Field field = CMDConf.class.getDeclaredField(fieldName);
                if (field.getType().equals(String.class)) {
                    field.set(this, cmdArg[1]);
                    continue;
                }
                if (field.getType().equals(Integer.TYPE)) {
                    field.set(this, Integer.parseInt(cmdArg[1]));
                    continue;
                }
                field.set(this, true);
            }
            catch (Exception e) {
                LOGGER.warn("cmd arg " + fieldName + " invalid! " + e.getMessage());
            }
        }
        if (this.doipPort == -1) {
            this.doipPort = this.servicePort + 2;
        }
        if (this.cmi.isEmpty() || !this.cmi.replaceAll("[^\\s]+", "").isEmpty()) {
            this.cmi = String.valueOf(System.currentTimeMillis());
            this.overwrite = true;
            LOGGER.info("create default cmi");
        }
        return this;
    }

    public void write(String path) {
        try {
            this.overwrite = false;
            BufferedWriter bw = new BufferedWriter(new FileWriter(path));
            bw.write(JsonUtil.toPrettyJson((Object)this));
            bw.flush();
            bw.close();
            LOGGER.info("write new configure");
        }
        catch (Exception e) {
            LOGGER.warn("write failed!");
        }
    }
}

