/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.server.action;

import java.io.FileNotFoundException;
import java.io.RandomAccessFile;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.sc.util.JsonUtil;
import org.bdware.server.action.Action;

public class ActionExecutor<T, U> {
    private static final Logger LOGGER = LogManager.getLogger(ActionExecutor.class);
    static Map<String, Map<String, AtomicInteger>> allData = new ConcurrentHashMap<String, Map<String, AtomicInteger>>();
    public ExecutorService executor;
    public long permission;
    Map<String, AtomicInteger> staticData;
    private Map<String, Pair<Method, Object>> handlers;
    private Object Constructor;

    public ActionExecutor(ExecutorService executor, Object ... classes) {
        this.executor = executor;
        this.permission = 0L;
        this.initHandlers(classes);
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        String caller = stackTraceElements[2].getClassName();
        caller = caller + (int)(Math.random() * 10000.0);
        this.staticData = new ConcurrentHashMap<String, AtomicInteger>();
        allData.putIfAbsent(caller, this.staticData);
    }

    public static Set<String> getAECallerSet() {
        return allData.keySet();
    }

    public static Map<String, AtomicInteger> getStatistic(String caller) {
        return allData.get(caller);
    }

    public static Map<String, Map<String, AtomicInteger>> getAllData() {
        return allData;
    }

    public Map<String, AtomicInteger> getStaticData() {
        return this.staticData;
    }

    private void initHandlers(Object ... objects) {
        this.handlers = new HashMap<String, Pair<Method, Object>>();
        if (objects.length > 0) {
            for (Object obj : objects) {
                this.appendHandler(obj);
            }
        }
    }

    public boolean checkPermission(Action a, U args, long permission) {
        return true;
    }

    public Map<String, Pair<Method, Object>> getHandlers() {
        return this.handlers;
    }

    public void appendHandler(Object obj) {
        try {
            Method[] methods;
            if (null == obj) {
                return;
            }
            for (Method method : methods = obj.getClass().getDeclaredMethods()) {
                if (null == method.getAnnotation(Action.class)) continue;
                if (method.getAnnotation(Action.class).alias().length == 0) {
                    this.handlers.put(method.getName(), new Pair<Method, Object>(method, obj));
                    if (method.getReturnType().equals(Void.TYPE) && method.getParameterCount() == 2) continue;
                    LOGGER.error("action ret is not void:" + obj.getClass().getCanonicalName() + "-->" + method.getName());
                    System.exit(0);
                    continue;
                }
                for (String a : method.getAnnotation(Action.class).alias()) {
                    this.handlers.put(a, new Pair<Method, Object>(method, obj));
                    if (method.getReturnType().equals(Void.TYPE) && method.getParameterCount() == 2) continue;
                    LOGGER.error("action ret is not void:" + obj.getClass().getCanonicalName() + "-->" + method.getName());
                    System.exit(0);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void handle(String action, U args, T callback) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (null != action) {
            if (this.staticData.containsKey(action)) {
                this.staticData.get(action).incrementAndGet();
            } else {
                this.staticData.put(action, new AtomicInteger(1));
            }
        }
        if (!this.handlers.containsKey(action)) {
            LOGGER.debug("unsupported action " + action + "->" + JsonUtil.toJson(args));
            throw new IllegalArgumentException("unsupported action " + action);
        }
        Pair<Method, Object> pair = this.handlers.get(action);
        Action actionAnnotations = ((Method)pair.first).getAnnotation(Action.class);
        if (!this.checkPermission(actionAnnotations, args, this.permission)) {
            LOGGER.info("unauthorised action " + action + " -> " + JsonUtil.toJson(args));
            throw new IllegalArgumentException("unauthorised action " + action);
        }
        if (actionAnnotations.async()) {
            this.executor.execute(() -> {
                try {
                    ((Method)pair.first).invoke(pair.second, args, callback);
                }
                catch (Exception e) {
                    LOGGER.debug(((Method)pair.first).getDeclaringClass().getCanonicalName() + "->" + ((Method)pair.first).getName());
                    e.printStackTrace();
                }
            });
        } else {
            ((Method)pair.first).invoke(pair.second, args, callback);
        }
    }

    public static class Pair<T, U> {
        T first;
        U second;

        public Pair(T f, U s) {
            this.first = f;
            this.second = s;
        }

        public T first() {
            return this.first;
        }
    }

    static class Profiler {
        RandomAccessFile log;

        Profiler() {
            try {
                this.log = new RandomAccessFile("./log/profile.log", "rw");
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }
}

