/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.server.action;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.sc.ContractResult;
import org.bdware.sc.conn.InstrumentedResultCallback;
import org.bdware.sc.conn.ResultCallback;
import org.bdware.sc.util.JsonUtil;

public class SyncResult {
    public static final HashedWheelTimer timer = new HashedWheelTimer(Executors.defaultThreadFactory(), 5L, TimeUnit.MILLISECONDS, 2);
    private static final Logger LOGGER = LogManager.getLogger(SyncResult.class);
    public Map<String, ResultCallback> waitObj = new ConcurrentHashMap<String, ResultCallback>();

    public synchronized void wakeUp(String requestID, String result) {
        ResultCallback ob = this.waitObj.get(requestID);
        this.waitObj.remove(requestID);
        if (ob != null) {
            ob.cancelTimeOut();
            ob.onResult(result);
        }
    }

    public void instrumentWakeUp(String requestID, InstrumentedResultCallback instrumentedResultCallback, JsonObject result) {
        ResultCallback ob = this.waitObj.get(requestID);
        this.waitObj.remove(requestID);
        if (ob != null) {
            ob.cancelTimeOut();
            instrumentedResultCallback.onResult(ob, result);
        }
    }

    public void sleep(String requestID, ResultCallback cb) {
        this.sleepWithTimeout(requestID, cb, 20);
    }

    public void sleepWithTimeout(String requestID, ResultCallback cb, int timeOut) {
        if (!this.waitObj.containsKey(requestID)) {
            CancelTask tt = new CancelTask(requestID);
            Timeout timeout = timer.newTimeout((TimerTask)tt, (long)timeOut, TimeUnit.SECONDS);
            cb.setTimeOut(timeout);
            this.waitObj.put(requestID, cb);
        } else {
            LOGGER.debug("[Duplicated RequestID]" + requestID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContractResult syncSleep(String requestID) {
        ContractResultCallback cb = new ContractResultCallback();
        this.sleep(requestID, cb);
        ContractResultCallback contractResultCallback = cb;
        synchronized (contractResultCallback) {
            try {
                ((Object)((Object)cb)).wait(20000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return cb.cr;
    }

    public boolean canIssue() {
        int waitSize = this.waitObj.keySet().size();
        return true;
    }

    class CancelTask
    implements TimerTask {
        String requestID;

        CancelTask(String requestID) {
            this.requestID = requestID;
        }

        public void run(Timeout timeout) {
            ContractResult cr = new ContractResult(ContractResult.Status.Error, (JsonElement)new JsonPrimitive("Timeout!"));
            SyncResult.this.wakeUp(this.requestID, JsonUtil.toJson((Object)cr));
        }
    }

    public static class ContractResultCallback
    extends ResultCallback {
        ContractResult cr = new ContractResult(ContractResult.Status.Error, (JsonElement)new JsonPrimitive("Timeout!!"));
        int reRoute = 0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onResult(String str) {
            this.cr = (ContractResult)JsonUtil.fromJson((String)str, ContractResult.class);
            ContractResultCallback contractResultCallback = this;
            synchronized (contractResultCallback) {
                ((Object)((Object)this)).notifyAll();
            }
        }

        public int getReRouteCount() {
            return this.reRoute;
        }

        public void incReRouteCount() {
            ++this.reRoute;
        }
    }
}

