/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.server.http;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URLDecoder;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.sc.util.ExceptionUtil;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.pqc.math.linearalgebra.ByteUtils;
import org.zz.gmhelper.BCECUtil;
import org.zz.gmhelper.SM2Util;

public class ArgParser {
    private static final Logger LOGGER = LogManager.getLogger(ArgParser.class);

    public static JsonObject parseGetAndVerify(FullHttpRequest msg, VerifiedCallback cb) throws Exception {
        QueryStringDecoder decoderQuery = new QueryStringDecoder(msg.uri());
        Map parameters = decoderQuery.parameters();
        JsonObject transformedParam = new JsonObject();
        for (String key : parameters.keySet()) {
            List val = (List)parameters.get(key);
            if (null == val) continue;
            transformedParam.addProperty(key, (String)val.get(0));
        }
        transformedParam.addProperty("permission", (Number)0);
        transformedParam.remove("verifiedPubKey");
        String uri = URLDecoder.decode(msg.uri(), "UTF-8").split("\\?")[1];
        int index = uri.lastIndexOf(38);
        if (index >= 0) {
            ArgParser.verifyParam(transformedParam, uri.substring(0, index), cb);
        }
        return transformedParam;
    }

    private static void verifyParam(JsonObject transformedParam, String toVerifyStr, VerifiedCallback cb) {
        boolean verify = false;
        if (transformedParam.has("pubKey")) {
            LOGGER.info("before verifying: " + toVerifyStr);
            try {
                ECPublicKeyParameters pubKey = BCECUtil.createECPublicKeyFromStrParameters((String)transformedParam.get("pubKey").getAsString(), (ECCurve)SM2Util.CURVE, (ECDomainParameters)SM2Util.DOMAIN_PARAMS);
                verify = SM2Util.verify((ECPublicKeyParameters)pubKey, (byte[])toVerifyStr.getBytes(), (byte[])ByteUtils.fromHexString((String)transformedParam.get("sign").getAsString()));
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
                LOGGER.debug(ExceptionUtil.exceptionToString((Throwable)e));
            }
        }
        if (cb != null) {
            cb.onResult(verify, transformedParam);
        }
    }

    public static JsonObject parsePostAndVerify(FullHttpRequest msg, VerifiedCallback cb) throws Exception {
        ByteBuf content = msg.content();
        JsonObject map = JsonParser.parseReader((Reader)new InputStreamReader((InputStream)new ByteBufInputStream(content))).getAsJsonObject();
        StringBuilder toSign = new StringBuilder();
        boolean isFirst = true;
        for (String key : map.keySet()) {
            if (key.equals("sign")) continue;
            if (!isFirst) {
                toSign.append("&");
            }
            isFirst = false;
            toSign.append(key).append("=");
            JsonElement je = map.get(key);
            if (je.isJsonPrimitive()) {
                toSign.append(je.getAsString());
                continue;
            }
            toSign.append(je.toString());
        }
        ArgParser.verifyParam(map, toSign.toString(), cb);
        return map;
    }

    public static interface VerifiedCallback {
        public void onResult(boolean var1, JsonObject var2);
    }
}

