/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.server.http;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelProgressiveFuture;
import io.netty.channel.ChannelProgressiveFutureListener;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultFileRegion;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import java.io.RandomAccessFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.server.action.HttpResultCallback;

public class FileDownloaderCallback
extends HttpResultCallback {
    private static final Logger LOGGER = LogManager.getLogger(FileDownloaderCallback.class);
    HttpRequest req;

    public FileDownloaderCallback(ChannelHandlerContext ctx, HttpRequest req) {
        super(ctx, null);
        this.req = req;
    }

    @Override
    public void onResult(final String filePath) {
        try {
            final RandomAccessFile file = new RandomAccessFile(filePath, "r");
            DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
            response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"application/x-msdownload");
            response.headers().set((CharSequence)HttpHeaderNames.CONTENT_DISPOSITION, (Object)("attachment;filename=" + new File(filePath).getName()));
            HttpUtil.setKeepAlive((HttpMessage)response, (boolean)HttpUtil.isKeepAlive((HttpMessage)this.req));
            HttpUtil.setContentLength((HttpMessage)response, (long)file.length());
            LOGGER.debug("FileLength:" + file.length());
            this.ctxField.write((Object)response);
            ChannelFuture future = this.ctxField.write((Object)new DefaultFileRegion(file.getChannel(), 0L, file.length()), (ChannelPromise)this.ctxField.newProgressivePromise());
            this.ctxField.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
            future.addListener((GenericFutureListener)new ChannelProgressiveFutureListener(){

                public void operationProgressed(ChannelProgressiveFuture future, long progress, long total) {
                }

                public void operationComplete(ChannelProgressiveFuture future) throws Exception {
                    file.close();
                    LOGGER.debug("delete file " + filePath + ": " + new File(filePath).delete());
                }
            });
            if (!HttpUtil.isKeepAlive((HttpMessage)this.req)) {
                future.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
            this.ctxField.flush();
        }
        catch (Exception e) {
            DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.wrappedBuffer((byte[])"File Not Found".getBytes()));
            ChannelFuture f = this.ctxField.writeAndFlush((Object)response);
            f.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            this.ctxField.close();
        }
    }
}

