/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.server.http;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.stream.ChunkedFile;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import java.io.FileFilter;
import java.io.RandomAccessFile;

public class HttpFileHandleAdapter
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private final String location;
    FileFilter fileFilter;

    public HttpFileHandleAdapter(String path, FileFilter fileFilter) {
        this.location = path;
        this.fileFilter = fileFilter;
    }

    public static void sendError(ChannelHandlerContext ctx, HttpResponseStatus status) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, Unpooled.wrappedBuffer((byte[])("Failure: " + status + "\r\n").getBytes()));
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/plain; charset=UTF-8");
        ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    public static void appendContentType(String path, HttpHeaders headers) {
        if (path.endsWith(".html")) {
            headers.set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/html; charset=UTF-8");
        } else if (path.endsWith(".js")) {
            headers.set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"application/x-javascript; charset=utf-8");
        } else if (path.endsWith(".css")) {
            headers.set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/css; charset=UTF-8");
        } else if (path.endsWith(".ico")) {
            headers.set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"image/x-icon;");
        } else if (path.endsWith(".svg")) {
            headers.set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"image/svg+xml;charset=utf-8");
        } else if (path.endsWith(".ypk")) {
            headers.set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"application/ypk");
        }
    }

    private static void send100Continue(ChannelHandlerContext ctx) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE);
        ctx.writeAndFlush((Object)response);
    }

    protected void channelRead0(ChannelHandlerContext ctx, FullHttpRequest request) throws Exception {
        boolean isTrue;
        request.retain();
        String uri = request.uri();
        if (uri.contains("..")) {
            HttpFileHandleAdapter.sendError(ctx, HttpResponseStatus.BAD_REQUEST);
            return;
        }
        uri = uri.replaceFirst("/SCIDE", "");
        if ((uri = uri.replaceFirst("\\?.*$", "")).equals("/") || uri.equals("./") || uri.length() == 0) {
            uri = "/index.html";
        }
        if (isTrue = this.isFile(uri)) {
            String path = this.location + uri;
            File html = new File(path);
            if (HttpUtil.is100ContinueExpected((HttpMessage)request)) {
                HttpFileHandleAdapter.send100Continue(ctx);
            }
            if (!html.exists() || html.isDirectory()) {
                HttpFileHandleAdapter.sendError(ctx, HttpResponseStatus.NOT_FOUND);
                return;
            }
            RandomAccessFile file = new RandomAccessFile(html, "r");
            DefaultHttpResponse response = new DefaultHttpResponse(request.protocolVersion(), HttpResponseStatus.OK);
            HttpFileHandleAdapter.appendContentType(path, response.headers());
            boolean keepAlive = HttpUtil.isKeepAlive((HttpMessage)request);
            HttpUtil.setContentLength((HttpMessage)response, (long)file.length());
            if (keepAlive) {
                HttpUtil.setKeepAlive((HttpMessage)response, (boolean)true);
            }
            ctx.write((Object)response);
            ctx.write((Object)new ChunkedFile(file, 0L, file.length(), 524288));
            ChannelFuture future = ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
            if (!keepAlive) {
                future.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
            future.addListener(arg0 -> file.close());
        } else {
            HttpFileHandleAdapter.sendError(ctx, HttpResponseStatus.NOT_FOUND);
        }
    }

    private boolean isFile(String path) {
        return this.fileFilter.accept(new File(path));
    }
}

