/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.server.http;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.sc.conn.ResultCallback;
import org.bdware.sc.util.JsonUtil;
import org.bdware.server.action.ActionExecutor;
import org.bdware.server.action.HttpResultCallback;
import org.bdware.server.action.IndexAction;
import org.bdware.server.http.FileDownloaderCallback;
import org.bdware.server.http.HttpMethod;

@ChannelHandler.Sharable
public class IndexHttpHandler
extends SimpleChannelInboundHandler<HttpObject> {
    private static final String PARAM_ACTION = "action";
    private static final String UNSUPPORTED_HTTP_METHOD = "{\"msg\":\"unsupported http method\"}";
    private static final String UNSUPPORTED_ACTION = "{\"msg\":\"unsupported action\"}";
    private static final Logger LOGGER = LogManager.getLogger(IndexHttpHandler.class);
    private static ActionExecutor<ResultCallback, JsonObject> actionExecutor = new ActionExecutor(Executors.newFixedThreadPool(5), new IndexAction());

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    public void channelRead0(ChannelHandlerContext ctx, HttpObject msg) {
        if (msg instanceof FullHttpRequest) {
            this.handleHttpRequest(ctx, (FullHttpRequest)msg);
        } else {
            LOGGER.info("[Ignore] " + msg.getClass().getCanonicalName());
        }
    }

    private void handleHttpRequest(ChannelHandlerContext ctx, FullHttpRequest msg) {
        if (!msg.uri().startsWith("/SCIDE/Index")) {
            try {
                DefaultFullHttpResponse fullResponse = new DefaultFullHttpResponse(msg.getProtocolVersion(), HttpResponseStatus.OK, Unpooled.wrappedBuffer((byte[])UNSUPPORTED_HTTP_METHOD.getBytes()));
                ChannelFuture f = ctx.write((Object)fullResponse);
                f.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return;
        }
        FullHttpRequest req = msg;
        DefaultFullHttpResponse fullResponse = null;
        io.netty.handler.codec.http.HttpMethod method = req.getMethod();
        if (method.equals((Object)HttpMethod.GET)) {
            QueryStringDecoder decoderQuery = new QueryStringDecoder(req.getUri());
            Map parame = decoderQuery.parameters();
            JsonObject transfomedParam = new JsonObject();
            for (String key : parame.keySet()) {
                List val = (List)parame.get(key);
                if (val == null) continue;
                transfomedParam.addProperty(key, (String)val.get(0));
            }
            this.handleReq(transfomedParam, ctx, (HttpRequest)req);
            return;
        }
        if (method.equals((Object)HttpMethod.POST)) {
            ByteBuf content = msg.content();
            byte[] reqContent = new byte[content.readableBytes()];
            content.readBytes(reqContent);
            try {
                String strContent = new String(reqContent, "UTF-8");
                JsonObject map = new JsonParser().parse(strContent).getAsJsonObject();
                this.handleReq(map, ctx, (HttpRequest)req);
                return;
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        } else {
            fullResponse = new DefaultFullHttpResponse(req.getProtocolVersion(), HttpResponseStatus.OK, Unpooled.wrappedBuffer((byte[])UNSUPPORTED_HTTP_METHOD.getBytes()));
        }
        ChannelFuture f = ctx.write((Object)fullResponse);
        f.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private void handleReq(JsonObject map, ChannelHandlerContext ctx, HttpRequest req) {
        try {
            byte[] ret = null;
            String action = null;
            if (!map.has(PARAM_ACTION)) {
                ret = UNSUPPORTED_ACTION.getBytes();
                DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.wrappedBuffer((byte[])ret));
                ChannelFuture f = ctx.write((Object)response);
                f.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                return;
            }
            action = map.get(PARAM_ACTION).getAsString();
            if (action != null) {
                HttpResultCallback cb;
                if (action.equals("downloadContract")) {
                    cb = new FileDownloaderCallback(ctx, req);
                } else if (map.has("callback")) {
                    cb = new HttpResultCallback(ctx, map.get("callback").getAsString());
                    cb.addHeader("Content-Type", "application/json");
                } else {
                    cb = new HttpResultCallback(ctx, null);
                    cb.addHeader("Content-Type", "application/json");
                }
                if (map.get(PARAM_ACTION).getAsString().equals("downloadUUID")) {
                    cb.addHeader("content-disposition", "attachment;filename=encodeduuid.key");
                }
                actionExecutor.handle(action, map, cb);
            }
        }
        catch (IllegalArgumentException e) {
            DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.wrappedBuffer((byte[])e.getMessage().getBytes()));
            ChannelFuture f = ctx.write((Object)response);
            f.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
        catch (Exception e) {
            HashMap<String, String> ret = new HashMap<String, String>();
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream(bo));
            ret.put("msg", bo.toString());
            DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.wrappedBuffer((byte[])JsonUtil.toJson(ret).getBytes()));
            ChannelFuture f = ctx.write((Object)response);
            f.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        cause.printStackTrace();
        ctx.close();
    }
}

