/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.server.http;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.concurrent.GenericFutureListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.server.http.HttpMethod;
import org.bdware.server.http.URIPath;

public class URIHandler {
    private static final Logger LOGGER = LogManager.getLogger(URIHandler.class);
    private Map<io.netty.handler.codec.http.HttpMethod, List<Tuple<String, Method, Object>>> handlers = new HashMap<io.netty.handler.codec.http.HttpMethod, List<Tuple<String, Method, Object>>>();

    public void register(Object obj) {
        this.register(obj.getClass(), obj);
    }

    public void register(Class<?> clz) {
        this.register(clz, null);
    }

    public void register(Class<?> clz, Object obj) {
        for (Method m : clz.getDeclaredMethods()) {
            URIPath path = m.getAnnotation(URIPath.class);
            if (path == null) continue;
            HttpMethod method = path.method();
            List<Tuple<String, Method, Object>> handlerList = this.getOrCreate(method);
            for (String str : path.value()) {
                m.setAccessible(true);
                handlerList.add(new Tuple<String, Method, Object>(str, m, obj));
            }
        }
        for (List list : this.handlers.values()) {
            this.sortHandlerList(list);
        }
    }

    protected List<Tuple<String, Method, Object>> getOrCreate(HttpMethod method) {
        return this.handlers.computeIfAbsent(method.get(), k -> new ArrayList());
    }

    private void sortHandlerList(List<Tuple<String, Method, Object>> handlerList) {
        handlerList.sort((o1, o2) -> {
            int delta = ((String)o2.t).length() - ((String)o1.t).length();
            return delta == 0 ? ((String)o1.t).compareTo((String)o2.t) : delta;
        });
    }

    public Tuple<String, Method, Object> findHandler(FullHttpRequest msg) {
        List<Tuple<String, Method, Object>> handlerList = this.handlers.get(msg.method());
        for (Tuple<String, Method, Object> t : handlerList) {
            if (!msg.uri().startsWith((String)t.t)) continue;
            return t;
        }
        return null;
    }

    public void handle(ChannelHandlerContext ctx, FullHttpRequest msg) {
        Tuple<String, Method, Object> t = this.findHandler(msg);
        this.handle(ctx, msg, t);
    }

    public void handle(ChannelHandlerContext ctx, FullHttpRequest msg, Tuple<String, Method, Object> t) {
        try {
            if (t != null) {
                ((Method)t.u).invoke(t.s, ctx, msg);
            } else {
                this.sendUnsupported(ctx);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void printURIHandlers() {
        StringBuilder sbl = new StringBuilder("URIHandlers:\n");
        for (io.netty.handler.codec.http.HttpMethod m : this.handlers.keySet()) {
            sbl.append("\t").append(m.name()).append("\n");
            for (Tuple<String, Method, Object> t : this.handlers.get(m)) {
                String className = ((Method)t.u).getDeclaringClass().getSimpleName();
                sbl.append("\t\t").append(((String)t.t).isEmpty() ? "<null>" : (String)t.t).append(" --> ").append(className.isEmpty() ? "null" : className).append(".").append(((Method)t.u).getName()).append("\n");
            }
        }
        LOGGER.info(sbl.substring(0, sbl.length() - 1));
    }

    private void sendUnsupported(ChannelHandlerContext ctx) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_REQUEST, Unpooled.wrappedBuffer((byte[])("Failure: " + HttpResponseStatus.BAD_REQUEST + "\r\n").getBytes()));
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/plain; charset=UTF-8");
        ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    public static class Tuple<T, U, S> {
        public T t;
        public U u;
        public S s;

        Tuple(T t, U u, S s) {
            this.t = t;
            this.u = u;
            this.s = s;
        }
    }
}

