/*
 * Decompiled with CFR 0.152.
 */
package org.beanfabrics.swing.goodies.calendar;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.io.Serializable;
import javax.swing.Icon;

class ArrowIcon
implements Icon,
Serializable {
    public static final int UP = 1;
    public static final int LEFT = 2;
    public static final int DOWN = 3;
    public static final int RIGHT = 4;
    private static final int nPoints = 3;
    private int orientation;
    private Dimension preferredSize = new Dimension(10, 10);
    private int[] xPoints = new int[3];
    private int[] yPoints = new int[3];
    private Color color;

    public ArrowIcon(int orientation) {
        this(orientation, Color.BLACK);
    }

    public ArrowIcon(int orientation, Color color) {
        this.orientation = orientation;
        this.color = color;
    }

    public void setPreferredSize(Dimension size) {
        this.preferredSize = size;
    }

    @Override
    public int getIconHeight() {
        return this.preferredSize.height;
    }

    @Override
    public int getIconWidth() {
        return this.preferredSize.width;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2d;
        int w = this.getIconWidth();
        int h = this.getIconHeight();
        this.recalculateShape(x, y, w, h);
        Object oldValueAntiAliasing = null;
        if (g instanceof Graphics2D) {
            g2d = (Graphics2D)g;
            oldValueAntiAliasing = g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        g.setColor(this.color);
        g.fillPolygon(this.xPoints, this.yPoints, 3);
        if (g instanceof Graphics2D) {
            g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldValueAntiAliasing);
        }
    }

    protected void recalculateShape(int x, int y, int w, int h) {
        switch (this.orientation) {
            case 1: {
                this.xPoints[0] = x;
                this.xPoints[1] = x + (w - 1) / 2;
                this.xPoints[2] = x + w - 1;
                this.yPoints[0] = y + h - 1;
                this.yPoints[1] = y;
                this.yPoints[2] = y + h - 1;
                break;
            }
            case 2: {
                this.xPoints[0] = x;
                this.xPoints[1] = x + w - 1;
                this.xPoints[2] = x + w - 1;
                this.yPoints[0] = y + (h - 1) / 2;
                this.yPoints[1] = y;
                this.yPoints[2] = y + h - 1;
                break;
            }
            case 3: {
                this.xPoints[0] = x;
                this.xPoints[1] = x + (w - 1) / 2;
                this.xPoints[2] = x + w - 1;
                this.yPoints[0] = y;
                this.yPoints[1] = y + h - 1;
                this.yPoints[2] = y;
                break;
            }
            case 4: {
                this.xPoints[0] = x;
                this.xPoints[1] = x + w - 1;
                this.xPoints[2] = x;
                this.yPoints[0] = y;
                this.yPoints[1] = y + (h - 1) / 2;
                this.yPoints[2] = y + h - 1;
                break;
            }
        }
    }
}

