/*
 * Decompiled with CFR 0.152.
 */
package org.beanfabrics.swing.goodies.calendar;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.text.JTextComponent;
import org.beanfabrics.swing.goodies.calendar.CalendarChooser;

public class CalendarButton
extends JButton
implements ActionListener {
    private JTextComponent textComponent;
    private JPopupMenu popup = null;
    private static final SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy");
    private CalendarChooser calendarBean;
    private int numberOfPreviousVisibleMonths = 0;
    private int numberOfSubsequentVisibleMonths = 0;
    private final PropertyChangeListener enableStateListener = new MyPropertyChangeListener();

    public CalendarButton() {
        this.addActionListener(this);
        this.setEnabled(this.textComponent != null ? this.textComponent.isEditable() : false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.textComponent == null) {
            return;
        }
        if (e.getSource() == this) {
            JPopupMenu p = this.getPopupMenu();
            String dateString = this.textComponent.getText();
            try {
                Date date = format.parse(dateString);
                this.getCalendarBean().setSelectedDate(date);
            }
            catch (ParseException ex) {
                this.getCalendarBean().setMonth(new Date());
                this.getCalendarBean().setSelectedDate(null);
            }
            p.show(this.textComponent, 0, this.textComponent.getSize().height);
        } else if (e.getSource() == this.getCalendarBean()) {
            JPopupMenu p = this.getPopupMenu();
            p.setVisible(false);
            Date date = this.getCalendarBean().getSelectedDate();
            if (date == null) {
                this.textComponent.setText("");
            } else {
                String dateString = format.format(date);
                this.textComponent.setText(dateString);
            }
        }
    }

    public void setTextComponent(JTextComponent newTextComponent) {
        JTextComponent oldTextComponent = this.textComponent;
        if (this.textComponent != null) {
            this.textComponent.removePropertyChangeListener("editable", this.enableStateListener);
        }
        this.textComponent = newTextComponent;
        if (this.textComponent != null) {
            this.textComponent.addPropertyChangeListener("editable", this.enableStateListener);
            this.setEnabled(this.textComponent.isEditable());
        }
        this.firePropertyChange("textComponent", oldTextComponent, newTextComponent);
    }

    public JTextComponent getTextComponent() {
        return this.textComponent;
    }

    protected JPopupMenu getPopupMenu() {
        if (this.popup == null) {
            this.popup = new JPopupMenu();
            this.popup.add(this.getCalendarBean());
        }
        return this.popup;
    }

    public void setDatePattern(String pattern) {
        String oldPattern = format.toPattern();
        format.applyPattern(pattern);
        this.firePropertyChange("datePattern", oldPattern, pattern);
    }

    public String getDatePattern() {
        return format.toPattern();
    }

    public void setCalendarBean(CalendarChooser newCalendarBean) {
        CalendarChooser oldCalendarBean = this.calendarBean;
        if (oldCalendarBean != null) {
            oldCalendarBean.removeActionListener(this);
        }
        this.calendarBean = newCalendarBean;
        this.calendarBean.addActionListener(this);
        this.firePropertyChange("calendarBean", oldCalendarBean, newCalendarBean);
    }

    public CalendarChooser getCalendarBean() {
        if (this.calendarBean == null) {
            this.calendarBean = new CalendarChooser();
            this.calendarBean.setNumberOfPreviousVisibleMonths(this.numberOfPreviousVisibleMonths);
            this.calendarBean.setNumberOfSubsequentVisibleMonths(this.numberOfSubsequentVisibleMonths);
            this.calendarBean.addActionListener(this);
        }
        return this.calendarBean;
    }

    public int getNumberOfPreviousVisibleMonths() {
        return this.numberOfPreviousVisibleMonths;
    }

    public void setNumberOfPreviousVisibleMonths(int numberOfPreviousVisibleMonths) {
        this.numberOfPreviousVisibleMonths = numberOfPreviousVisibleMonths;
    }

    public int getNumberOfSubsequentVisibleMonths() {
        return this.numberOfSubsequentVisibleMonths;
    }

    public void setNumberOfSubsequentVisibleMonths(int numberOfSubsequentVisibleMonths) {
        this.numberOfSubsequentVisibleMonths = numberOfSubsequentVisibleMonths;
    }

    private class MyPropertyChangeListener
    implements PropertyChangeListener,
    Serializable {
        private MyPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() != CalendarButton.this.textComponent) {
                return;
            }
            boolean newValue = (Boolean)evt.getNewValue();
            CalendarButton.this.setEnabled(newValue);
        }
    }
}

