/*
 * Decompiled with CFR 0.152.
 */
package org.beanfabrics.swing.goodies.calendar;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.beanfabrics.swing.goodies.calendar.ArrowIcon;
import org.beanfabrics.swing.goodies.calendar.MonthPanel;

public class CalendarChooser
extends JPanel {
    private static final String FORWARD_ACTION = "forward";
    private static final String BACK_Action = "back";
    private static final ArrowIcon LEFT_ICON = new ArrowIcon(2);
    private static final ArrowIcon RIGHT_ICON = new ArrowIcon(4);
    public static final String SELECTEDDATE_PROPERTYNAME = "selectedDate";
    private MonthPanel.Configuration config = new MonthPanel.Configuration();
    private Dimension rollButtonSize = new Dimension(10, 10);
    private int numberOfPreviousVisibleMonths = 0;
    private int numberOfSubsequentVisibleMonths = 0;
    private Locale locale;
    private Date selectedDate = null;
    private GridLayout gridLayout = new GridLayout();
    private final ButtonGroup group = new ButtonGroup();
    private MonthPanel centerMonthPanel;
    private MonthPanel[] preMonthPanel = new MonthPanel[0];
    private MonthPanel[] postMonthPanel = new MonthPanel[0];
    private JButton oneMonthBack = new JButton(LEFT_ICON);
    private JButton oneMonthForward = new JButton(RIGHT_ICON);
    private final ActionListener actionListener = new MyActionListener();
    private final ActionListener monthActionListener = new MonthActionListener();
    private ArrayList<ActionListener> actionListeners;

    public CalendarChooser() {
        this(new Date(), Locale.getDefault());
    }

    public CalendarChooser(Date date, Locale locale) {
        this.locale = locale;
        this.centerMonthPanel = new MonthPanel(date, locale, this.group);
        this.centerMonthPanel.setConfiguration(this.config);
        this.centerMonthPanel.addActionListener(this.monthActionListener);
        this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.gridLayout.setHgap(2);
        this.gridLayout.setVgap(2);
        this.setLayout(new BorderLayout(1, 1));
        this.oneMonthBack.setActionCommand(BACK_Action);
        this.oneMonthBack.addActionListener(this.actionListener);
        this.oneMonthForward.setActionCommand(FORWARD_ACTION);
        this.oneMonthForward.addActionListener(this.actionListener);
        this.initGui();
        this.setDates(date, date);
    }

    protected void initGui() {
        int i;
        this.removeAll();
        JPanel calendarPanel = new JPanel(this.gridLayout);
        calendarPanel.setOpaque(false);
        this.add((Component)calendarPanel, "Center");
        this.gridLayout.setRows(1);
        this.gridLayout.setColumns(this.numberOfPreviousVisibleMonths + 1 + this.numberOfSubsequentVisibleMonths);
        for (i = 0; i < this.preMonthPanel.length; ++i) {
            this.preMonthPanel[i].initGui();
            calendarPanel.add(this.preMonthPanel[i]);
        }
        this.centerMonthPanel.initGui();
        calendarPanel.add(this.centerMonthPanel);
        for (i = 0; i < this.postMonthPanel.length; ++i) {
            this.postMonthPanel[i].initGui();
            calendarPanel.add(this.postMonthPanel[i]);
        }
        this.addRollButtons();
        this.validate();
    }

    private void addRollButtons() {
        EmptyBorder emptyBorder = new EmptyBorder(0, 0, 0, 0);
        LEFT_ICON.setPreferredSize(this.rollButtonSize);
        LEFT_ICON.setColor(this.config.getHeaderForegroundColor());
        RIGHT_ICON.setPreferredSize(this.rollButtonSize);
        RIGHT_ICON.setColor(this.config.getHeaderForegroundColor());
        this.oneMonthBack.setMargin(new Insets(1, 1, 1, 1));
        this.oneMonthBack.setBorder(emptyBorder);
        this.oneMonthBack.setBorderPainted(false);
        this.oneMonthBack.setContentAreaFilled(false);
        this.oneMonthBack.setOpaque(false);
        this.oneMonthForward.setMargin(new Insets(1, 1, 1, 1));
        this.oneMonthForward.setBorder(emptyBorder);
        this.oneMonthForward.setBorderPainted(false);
        this.oneMonthForward.setContentAreaFilled(false);
        this.oneMonthForward.setOpaque(false);
        if (this.preMonthPanel.length > 0) {
            this.preMonthPanel[0].setLeftUpperCornerComponent(this.oneMonthBack);
        } else {
            this.centerMonthPanel.setLeftUpperCornerComponent(this.oneMonthBack);
        }
        if (this.postMonthPanel.length > 0) {
            this.postMonthPanel[this.postMonthPanel.length - 1].setRightUpperCornerComponent(this.oneMonthForward);
        } else {
            this.centerMonthPanel.setRightUpperCornerComponent(this.oneMonthForward);
        }
    }

    public void rollOneMonthForward() {
        this.centerMonthPanel.rollOneMonthForward();
        this.refresh();
    }

    public void rollOneMonthBack() {
        this.centerMonthPanel.rollOneMonthBack();
        this.refresh();
    }

    public void setDates(Date month, Date selectedDate) {
        this.setMonth(month);
        this.setSelectedDate(selectedDate, false);
    }

    public void setSelectedDate(Date date) {
        this.setSelectedDate(date, true);
    }

    public void setSelectedDate(Date date, boolean rollToMonth) {
        Date oldSelectedDate = this.selectedDate == null ? null : (Date)this.selectedDate.clone();
        this.centerMonthPanel.setSelectedDate(date, rollToMonth);
        this.selectedDate = date;
        this.refresh();
        this.firePropertyChange(SELECTEDDATE_PROPERTYNAME, oldSelectedDate, this.selectedDate);
    }

    private void refresh() {
        Date showMonth;
        int months;
        int i;
        Date month = this.centerMonthPanel.getMonth();
        for (i = 0; i < this.preMonthPanel.length; ++i) {
            months = this.preMonthPanel.length - i;
            showMonth = CalendarChooser.addMonths(month, -months);
            this.preMonthPanel[i].setMonth(showMonth);
            this.preMonthPanel[i].setSelectedDate(this.selectedDate, false);
        }
        for (i = 0; i < this.postMonthPanel.length; ++i) {
            months = i + 1;
            showMonth = CalendarChooser.addMonths(month, months);
            this.postMonthPanel[i].setMonth(showMonth);
            this.postMonthPanel[i].setSelectedDate(this.selectedDate, false);
        }
    }

    private static Date addMonths(Date date, int months) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(2, months);
        return cal.getTime();
    }

    public Date getSelectedDate() {
        return this.selectedDate;
    }

    public Date getMonth() {
        return this.centerMonthPanel.getMonth();
    }

    public void setMonth(Date month) {
        this.centerMonthPanel.setMonth(month);
        this.refresh();
    }

    public synchronized void removeActionListener(ActionListener l) {
        if (this.actionListeners != null && this.actionListeners.contains(l)) {
            ArrayList<ActionListener> als = new ArrayList<ActionListener>(this.actionListeners);
            als.remove(l);
            this.actionListeners = als;
        }
    }

    public synchronized void addActionListener(ActionListener l) {
        ArrayList<ActionListener> als;
        ArrayList<ActionListener> arrayList = als = this.actionListeners == null ? new ArrayList<ActionListener>(2) : new ArrayList<ActionListener>(this.actionListeners);
        if (!als.contains(l)) {
            als.add(l);
            this.actionListeners = als;
        }
    }

    protected void fireActionPerformed(ActionEvent e) {
        if (this.actionListeners != null) {
            for (ActionListener l : this.actionListeners) {
                l.actionPerformed(e);
            }
        }
    }

    public void setWeekendColor(Color weekendColor) {
        this.config.setWeekendForegroundColor(weekendColor);
        this.rebuildGui();
    }

    public Color getWeekendColor() {
        return this.config.getWeekendForegroundColor();
    }

    public void setWorkdayColor(Color workdayColor) {
        this.config.setWorkdayForegroundColor(workdayColor);
        this.rebuildGui();
    }

    public Color getWorkdayColor() {
        return this.config.getWorkdayForegroundColor();
    }

    public void setSelectedColor(Color selectedColor) {
        this.config.setSelectedColor(selectedColor);
        this.rebuildGui();
    }

    public Color getSelectedColor() {
        return this.config.getSelectedColor();
    }

    public void setSelectedBackgroundColor(Color selectedBackgroundColor) {
        this.config.setSelectedBackgroundColor(selectedBackgroundColor);
        this.rebuildGui();
    }

    public Color getSelectedBackgroundColor() {
        return this.config.getSelectedBackgroundColor();
    }

    public void setDayBackground(Color dayBackground) {
        this.config.setBackgroundColor(dayBackground);
        this.rebuildGui();
    }

    public Color getDayBackground() {
        return this.config.getBackgroundColor();
    }

    public void setHeaderFont(Font headerFont) {
        this.config.setHeaderFont(headerFont);
        this.rebuildGui();
    }

    public Font getHeaderFont() {
        return this.config.getHeaderFont();
    }

    public void setHeaderForegroundColor(Color c) {
        this.config.setHeaderForegroundColor(c);
        this.rebuildGui();
    }

    public Color getHeaderForegroundColor() {
        return this.config.getHeaderForegroundColor();
    }

    public void setDayFont(Font dayFont) {
        this.config.setDayFont(dayFont);
        this.rebuildGui();
    }

    public Font getDayFont() {
        return this.config.getDayFont();
    }

    public void setDateFont(Font dateFont) {
        this.config.setDateFont(dateFont);
        this.rebuildGui();
    }

    public Font getDateFont() {
        return this.config.getDateFont();
    }

    public void setDayMargin(Insets dayMargin) {
        this.config.setDayMargin(dayMargin);
        this.rebuildGui();
    }

    public Insets getDayMargin() {
        return this.config.getDayMargin();
    }

    public void setRollButtonSize(Dimension newSize) {
        this.rollButtonSize = newSize;
        this.rebuildGui();
    }

    public Dimension getRollButtonSize() {
        return this.rollButtonSize;
    }

    public void setNumberOfPreviousVisibleMonths(int number) {
        if (number < 0) {
            throw new IllegalArgumentException("number must be >= 0");
        }
        this.numberOfPreviousVisibleMonths = number;
        MonthPanel[] panels = this.createMonthPanels(this.numberOfPreviousVisibleMonths);
        this.setPreMonthPanels(panels);
    }

    public int getNumberOfPreviousVisibleMonths() {
        return this.numberOfPreviousVisibleMonths;
    }

    public void setNumberOfSubsequentVisibleMonths(int number) {
        if (number < 0) {
            throw new IllegalArgumentException("number must be >= 0");
        }
        this.numberOfSubsequentVisibleMonths = number;
        MonthPanel[] panels = this.createMonthPanels(this.numberOfSubsequentVisibleMonths);
        this.setPostMonthPanels(panels);
    }

    public int getNumberOfSubsequentVisibleMonths() {
        return this.numberOfSubsequentVisibleMonths;
    }

    private MonthPanel[] createMonthPanels(int number) {
        MonthPanel[] panels = new MonthPanel[number];
        for (int i = 0; i < panels.length; ++i) {
            panels[i] = new MonthPanel(this.centerMonthPanel.getMonth(), this.locale);
        }
        return panels;
    }

    private void onAddMonthPanel(MonthPanel panel) {
        panel.addActionListener(this.monthActionListener);
        panel.setButtonGroup(this.group);
        panel.setConfiguration(this.config);
    }

    private void onRemoveMonthPanel(MonthPanel panel) {
        panel.removeActionListener(this.monthActionListener);
        panel.setButtonGroup(null);
    }

    private void setPreMonthPanels(MonthPanel[] panels) {
        int i;
        if (this.preMonthPanel != null) {
            for (i = 0; i < this.preMonthPanel.length; ++i) {
                this.onRemoveMonthPanel(this.preMonthPanel[i]);
            }
        }
        this.preMonthPanel = panels;
        if (this.preMonthPanel != null) {
            for (i = 0; i < this.preMonthPanel.length; ++i) {
                this.onAddMonthPanel(this.preMonthPanel[i]);
            }
        }
        this.rebuildGui();
    }

    private void setPostMonthPanels(MonthPanel[] panels) {
        int i;
        if (this.postMonthPanel != null) {
            for (i = 0; i < this.postMonthPanel.length; ++i) {
                this.onRemoveMonthPanel(this.postMonthPanel[i]);
            }
        }
        this.postMonthPanel = panels;
        if (this.postMonthPanel != null) {
            for (i = 0; i < this.postMonthPanel.length; ++i) {
                this.onAddMonthPanel(this.postMonthPanel[i]);
            }
        }
        this.rebuildGui();
    }

    private void rebuildGui() {
        this.initGui();
        this.refresh();
    }

    @Override
    public void updateUI() {
        if (this.config != null) {
            this.config.updateUI();
            this.rebuildGui();
        }
        super.updateUI();
    }

    private class MonthActionListener
    implements ActionListener,
    Serializable {
        private MonthActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MonthPanel monthPanel = (MonthPanel)e.getSource();
            Date selDate = monthPanel.getSelectedDate();
            CalendarChooser.this.setSelectedDate(selDate, false);
            CalendarChooser.this.fireActionPerformed(new ActionEvent(CalendarChooser.this, e.getID(), e.getActionCommand(), e.getWhen(), e.getModifiers()));
        }
    }

    private class MyActionListener
    implements ActionListener,
    Serializable {
        private MyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (CalendarChooser.BACK_Action.equals(e.getActionCommand())) {
                CalendarChooser.this.rollOneMonthBack();
            } else if (CalendarChooser.FORWARD_ACTION.equals(e.getActionCommand())) {
                CalendarChooser.this.rollOneMonthForward();
            }
        }
    }
}

