/*
 * Decompiled with CFR 0.152.
 */
package org.beanfabrics.swing.goodies.calendar;

import java.awt.Color;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.net.URL;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.beanfabrics.View;
import org.beanfabrics.event.WeakPropertyChangeListener;
import org.beanfabrics.model.ConversionException;
import org.beanfabrics.model.IDatePM;
import org.beanfabrics.swing.goodies.calendar.CalendarChooser;

public class DatePMCalendarChooserButton
extends JButton
implements View<IDatePM> {
    private static final URL ICON_URL = DatePMCalendarChooserButton.class.getResource("bn_calendarchooser_obj16.png");
    private static final ImageIcon ICON = new ImageIcon(ICON_URL);
    private final WeakPropertyChangeListener listener = new MyWeakPropertyChangeListener();
    private IDatePM pModel;
    private CalendarChooser calendarChooser;
    private JPopupMenu popup;
    private boolean dateSelected;
    private final ActionListener myActionListener = new MyActionListener();
    private final PropertyChangeListener calendarChooserListener = new MyPropertyChangeListener();

    public DatePMCalendarChooserButton() {
        this(0, 0);
    }

    public DatePMCalendarChooserButton(int prevVisMonths, int subsVisMonths) {
        super(ICON);
        this.setMargin(new Insets(0, 0, 0, 0));
        this.setContentAreaFilled(false);
        this.addActionListener(this.myActionListener);
        CalendarChooser cc = this.getCalendarChooser();
        cc.setNumberOfPreviousVisibleMonths(prevVisMonths);
        cc.setNumberOfSubsequentVisibleMonths(subsVisMonths);
        this.refresh();
    }

    public IDatePM getPresentationModel() {
        return this.pModel;
    }

    public void setPresentationModel(IDatePM newModel) {
        IDatePM oldModel = this.pModel;
        if (this.pModel != null) {
            this.pModel.removePropertyChangeListener((PropertyChangeListener)this.listener);
        }
        this.pModel = newModel;
        if (this.pModel != null) {
            this.pModel.addPropertyChangeListener((PropertyChangeListener)this.listener);
        }
        this.refresh();
        this.firePropertyChange("presentationModel", oldModel, newModel);
    }

    boolean isConnected() {
        return this.pModel != null;
    }

    private void refresh() {
        if (this.isConnected()) {
            String tooltip;
            try {
                Date date = this.getPresentationModel().getDate();
                this.calendarChooser.setSelectedDate(date);
            }
            catch (ConversionException ce) {
                this.calendarChooser.setSelectedDate(null);
            }
            if (this.pModel.isValid()) {
                tooltip = this.pModel.getDescription();
                this.setBackground(null);
            } else {
                tooltip = this.pModel.getValidationState().getMessage();
                this.setBackground(Color.RED);
            }
            this.setToolTipText(tooltip);
            boolean editable = this.pModel.isEditable();
            this.setEnabled(editable);
        } else {
            this.setToolTipText(null);
            this.setEnabled(false);
        }
    }

    private void setDate(Date date) {
        if (this.pModel != null) {
            this.pModel.setDate(date);
        }
    }

    public JPopupMenu createPopup() {
        if (this.popup == null) {
            this.popup = new JPopupMenu(){

                @Override
                public void setVisible(boolean b) {
                    Boolean isCanceled = (Boolean)this.getClientProperty("JPopupMenu.firePopupMenuCanceled");
                    if (b || !b && DatePMCalendarChooserButton.this.dateSelected || isCanceled != null && !b && isCanceled.booleanValue()) {
                        super.setVisible(b);
                    }
                }
            };
            this.popup.setLightWeightPopupEnabled(true);
        }
        this.popup.removeAll();
        this.popup.add(this.getCalendarChooser());
        return this.popup;
    }

    public CalendarChooser getCalendarChooser() {
        if (this.calendarChooser == null) {
            CalendarChooser chooser = new CalendarChooser();
            chooser.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            chooser.setOpaque(false);
            this.setCalendarChooser(chooser);
        }
        return this.calendarChooser;
    }

    public void setCalendarChooser(CalendarChooser aCalendarChooser) {
        if (this.calendarChooser != null) {
            this.calendarChooser.removePropertyChangeListener("selectedDate", this.calendarChooserListener);
        }
        this.calendarChooser = aCalendarChooser;
        if (this.calendarChooser != null) {
            this.calendarChooser.addPropertyChangeListener("selectedDate", this.calendarChooserListener);
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setEnabled(this.isEnabled());
        if (this.calendarChooser != null) {
            SwingUtilities.updateComponentTreeUI(this.calendarChooser);
        }
        if (this.popup != null) {
            SwingUtilities.updateComponentTreeUI(this.popup);
        }
    }

    private class MyPropertyChangeListener
    implements PropertyChangeListener,
    Serializable {
        private MyPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("selectedDate") && DatePMCalendarChooserButton.this.popup != null && DatePMCalendarChooserButton.this.popup.isVisible()) {
                DatePMCalendarChooserButton.this.dateSelected = true;
                DatePMCalendarChooserButton.this.popup.setVisible(false);
                Date selectedDate = DatePMCalendarChooserButton.this.getCalendarChooser().getSelectedDate();
                DatePMCalendarChooserButton.this.setDate(selectedDate);
            }
        }
    }

    private class MyActionListener
    implements ActionListener,
    Serializable {
        private MyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JPopupMenu popup = DatePMCalendarChooserButton.this.createPopup();
            int x = DatePMCalendarChooserButton.this.getWidth() - popup.getPreferredSize().width;
            int y = DatePMCalendarChooserButton.this.getHeight();
            DatePMCalendarChooserButton.this.dateSelected = false;
            popup.show(DatePMCalendarChooserButton.this, x, y);
        }
    }

    private class MyWeakPropertyChangeListener
    implements WeakPropertyChangeListener,
    Serializable {
        private MyWeakPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            DatePMCalendarChooserButton.this.refresh();
        }
    }
}

