/*
 * Decompiled with CFR 0.152.
 */
package org.beanfabrics.swing.goodies.calendar;

import java.awt.BorderLayout;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.border.EmptyBorder;
import org.beanfabrics.swing.goodies.calendar.MonthPanelUISettings;
import org.beanfabrics.swing.goodies.calendar.MonthPanelUISettingsDefaults;

public class MonthPanel
extends JPanel {
    private static final int ROWS = 7;
    private static final int COLS = 7;
    public static final String SELECTEDDATE_PROPERTYNAME = "selectedDate";
    private Configuration config = new Configuration();
    private Locale locale = null;
    private Calendar month;
    private Calendar selectedDate = null;
    private DateFormat format = null;
    private DateFormatSymbols dateSymbols = null;
    private JComponent leftUpperCornerComponent = null;
    private JComponent rightUpperCornerComponent = null;
    private GridLayout gridLayout1 = new GridLayout();
    private String[] dayName = null;
    private JLabel[] headerLabel = new JLabel[7];
    private JToggleButton[][] button = new JToggleButton[7][7];
    private JPanel controlPanel;
    private ButtonGroup group;
    private JLabel dateLabel = new JLabel("September 2000");
    private final ItemListener itemListener = new MyItemListener();
    private final ActionListener dayActionListener = new MyActionListener();
    private Vector<ActionListener> actionListeners;
    boolean pendingShowMonth = false;
    private Date tempDate = new Date();
    private Calendar tempCal = null;

    public MonthPanel() {
        this(new Date(), Locale.getDefault(), new ButtonGroup());
    }

    public MonthPanel(Date date, Locale locale) {
        this(date, locale, new ButtonGroup());
    }

    public MonthPanel(ButtonGroup buttonGroup) {
        this(new Date(), Locale.getDefault(), buttonGroup);
    }

    public MonthPanel(Date date, Locale locale, ButtonGroup buttonGroup) {
        this.locale = locale;
        this.group = buttonGroup;
        Calendar month = Calendar.getInstance(locale);
        month.setTime(date);
        this.format = new SimpleDateFormat("MMMM yyyy", this.locale);
        this.dateSymbols = new DateFormatSymbols(this.locale);
        this.setLayout(new BorderLayout(1, 1));
        this.setOpaque(false);
        this.initGui();
        this.setMonth(month);
    }

    public ButtonGroup getButtonGroup() {
        return this.group;
    }

    public void setButtonGroup(ButtonGroup group) {
        int x;
        int y;
        if (this.group != null) {
            for (y = 1; y < 7; ++y) {
                for (x = 0; x < 7; ++x) {
                    if (this.button[y][x] == null) continue;
                    this.group.remove(this.button[y][x]);
                }
            }
        }
        this.group = group;
        if (this.group != null) {
            for (y = 1; y < 7; ++y) {
                for (x = 0; x < 7; ++x) {
                    if (this.button[y][x] == null) continue;
                    group.add(this.button[y][x]);
                }
            }
        }
        this.rebuildGui();
    }

    public void setConfiguration(Configuration config) {
        this.config = config;
        this.rebuildGui();
    }

    public void setLeftUpperCornerComponent(JComponent comp) {
        if (this.controlPanel != null && this.leftUpperCornerComponent != null) {
            this.controlPanel.remove(this.leftUpperCornerComponent);
        }
        this.leftUpperCornerComponent = comp;
        if (this.controlPanel != null && this.leftUpperCornerComponent != null) {
            this.controlPanel.add("West", this.leftUpperCornerComponent);
        }
    }

    public void setRightUpperCornerComponent(JComponent comp) {
        if (this.controlPanel != null && this.rightUpperCornerComponent != null) {
            this.controlPanel.remove(this.rightUpperCornerComponent);
        }
        this.rightUpperCornerComponent = comp;
        if (this.controlPanel != null && this.rightUpperCornerComponent != null) {
            this.controlPanel.add("East", this.rightUpperCornerComponent);
        }
    }

    public void initGui() {
        this.removeAll();
        for (int y = 1; y < 7; ++y) {
            for (int x = 0; x < 7; ++x) {
                if (this.button[y][x] != null) continue;
                this.button[y][x] = new JToggleButton("  "){

                    @Override
                    public void paintComponent(Graphics g) {
                        if (this.isSelected()) {
                            g.setColor(MonthPanel.this.config.getSelectedBackgroundColor());
                        } else {
                            g.setColor(this.getBackground());
                        }
                        g.fillRect(0, 0, this.getWidth(), this.getHeight());
                        super.paintComponent(g);
                    }
                };
                this.button[y][x].setContentAreaFilled(false);
                this.button[y][x].setBorderPainted(false);
                this.button[y][x].setBorder(null);
                this.button[y][x].setFocusPainted(false);
                this.button[y][x].addItemListener(this.itemListener);
                this.button[y][x].addActionListener(this.dayActionListener);
                if (this.group == null) continue;
                this.group.add(this.button[y][x]);
            }
        }
        EmptyBorder emptyBorder = new EmptyBorder(0, 0, 0, 0);
        if (this.controlPanel == null) {
            this.controlPanel = new JPanel(new BorderLayout());
            this.controlPanel.setOpaque(false);
            this.controlPanel.add("Center", this.dateLabel);
            if (this.leftUpperCornerComponent != null) {
                this.controlPanel.add("West", this.leftUpperCornerComponent);
            }
            if (this.rightUpperCornerComponent != null) {
                this.controlPanel.add("East", this.rightUpperCornerComponent);
            }
        }
        this.add("North", this.controlPanel);
        this.dateLabel.setHorizontalAlignment(0);
        this.dateLabel.setFont(this.config.getDateFont());
        this.dateLabel.setForeground(this.config.getHeaderForegroundColor());
        this.dateLabel.setOpaque(false);
        JPanel calendarPanel = new JPanel(this.gridLayout1);
        calendarPanel.setOpaque(false);
        this.add("Center", calendarPanel);
        this.gridLayout1.setColumns(7);
        this.gridLayout1.setRows(7);
        for (int x = 0; x < 7; ++x) {
            if (this.headerLabel[x] == null) {
                this.headerLabel[x] = new JLabel("XX");
                this.headerLabel[x].setOpaque(false);
            }
            this.headerLabel[x].setHorizontalAlignment(0);
            this.headerLabel[x].setFont(this.config.getHeaderFont());
            this.headerLabel[x].setForeground(this.config.getHeaderForegroundColor());
            calendarPanel.add(this.headerLabel[x]);
        }
        for (int y = 1; y < 7; ++y) {
            for (int x = 0; x < 7; ++x) {
                this.button[y][x].setFont(this.config.getDayFont());
                this.button[y][x].setMargin(this.config.getDayMargin());
                this.button[y][x].setBorder(emptyBorder);
                this.button[y][x].setBackground(this.config.getBackgroundColor());
                calendarPanel.add(this.button[y][x]);
            }
        }
        this.validate();
    }

    public void rollOneMonthForward() {
        this.month.add(2, 1);
        this.refresh();
    }

    public void rollOneMonthBack() {
        this.month.add(2, -1);
        this.refresh();
    }

    public void setSelectedDay(int dayInMonth) {
        Calendar cal = (Calendar)this.month.clone();
        cal.set(5, dayInMonth);
        this.setSelectedDate(cal.getTime());
    }

    public void setSelectedDate(Date date) {
        this.setSelectedDate(date, true);
    }

    public void setDates(Date month, Date selectedDate) {
        this.setMonth(month);
        this.setSelectedDate(selectedDate, false);
    }

    public void setSelectedDate(Date date, boolean rollToMonth) {
        if (date == null) {
            this.selectedDate = null;
            this.refresh();
            if (rollToMonth) {
                this.setMonth(new Date());
            }
        } else {
            if (this.selectedDate == null) {
                this.selectedDate = (Calendar)this.month.clone();
            }
            this.selectedDate.setTime(date);
            if (rollToMonth) {
                this.setMonth(date);
            } else {
                this.refresh();
            }
        }
    }

    public Date getSelectedDate() {
        if (this.selectedDate == null) {
            return null;
        }
        return this.selectedDate.getTime();
    }

    public Date getMonth() {
        return this.month.getTime();
    }

    public void setMonth(Date month) {
        if (month == null) {
            throw new NullPointerException("Illeagal null argument for month.");
        }
        this.month.setTime(month);
        this.refresh();
    }

    public void setMonth(Calendar month) {
        if (month == null) {
            throw new NullPointerException("Illeagal null argument for month.");
        }
        this.month = (Calendar)month.clone();
        this.format.setCalendar((Calendar)this.month.clone());
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refresh() {
        if (this.pendingShowMonth) {
            return;
        }
        this.pendingShowMonth = true;
        try {
            int selectedDay = -1;
            if (this.selectedDate != null && this.selectedDate.get(1) == this.month.get(1) && this.selectedDate.get(2) == this.month.get(2)) {
                selectedDay = this.selectedDate.get(5);
            }
            if (this.group != null) {
                this.group.setSelected(null, true);
            }
            int todayDate = -1;
            Calendar today = Calendar.getInstance();
            if (today.get(1) == this.month.get(1) && today.get(2) == this.month.get(2)) {
                todayDate = today.get(5);
            }
            for (int x = 0; x < 7; ++x) {
                this.headerLabel[x].setText(this.getDayNames()[x]);
            }
            int[][] dates = this.getDatesForButtons(this.month);
            for (int y = 0; y < 6; ++y) {
                for (int x = 0; x < 7; ++x) {
                    int dayOfMonth = dates[y][x];
                    this.button[y + 1][x].setSelected(false);
                    if (dayOfMonth != 0) {
                        this.button[y + 1][x].setText("" + dayOfMonth);
                        this.button[y + 1][x].setEnabled(true);
                        this.configure(this.button[y + 1][x], dayOfMonth, selectedDay, todayDate);
                        if (dayOfMonth == selectedDay) {
                            this.button[y + 1][x].setSelected(true);
                            continue;
                        }
                        this.deselectButton(this.button[y + 1][x]);
                        continue;
                    }
                    this.button[y + 1][x].setText("");
                    this.button[y + 1][x].setEnabled(false);
                    this.deselectButton(this.button[y + 1][x]);
                }
            }
            this.dateLabel.setText(this.formatDate(this.month.getTime()));
        }
        finally {
            this.pendingShowMonth = false;
        }
    }

    private void deselectButton(JToggleButton btn) {
        if (this.group != null) {
            this.group.remove(btn);
        }
        btn.setSelected(false);
        if (this.group != null) {
            this.group.add(btn);
        }
    }

    private void configure(JToggleButton btn, int dayOfMonth, int selectedDay, int todayDate) {
        if (dayOfMonth == selectedDay) {
            btn.setForeground(this.config.getSelectedColor());
            if (this.config.getSelectedBackgroundColor() != null) {
                btn.setBackground(this.config.getSelectedBackgroundColor());
            }
        } else {
            if (dayOfMonth == todayDate) {
                btn.setForeground(this.config.getTodayForegroundColor());
            } else if (this.isWeekend(dayOfMonth)) {
                btn.setForeground(this.config.getWeekendForegroundColor());
            } else {
                btn.setForeground(this.config.getWorkdayForegroundColor());
            }
            btn.setBackground(this.config.getBackgroundColor());
        }
    }

    protected String[] getDayNames() {
        if (this.dayName == null) {
            int delta;
            String[] shortWeekdays = this.dateSymbols.getShortWeekdays();
            int firstDayOfWeek = this.month.getFirstDayOfWeek();
            switch (firstDayOfWeek) {
                case 1: {
                    delta = 0;
                    break;
                }
                case 2: {
                    delta = 1;
                    break;
                }
                case 3: {
                    delta = 2;
                    break;
                }
                case 4: {
                    delta = 3;
                    break;
                }
                case 5: {
                    delta = 4;
                    break;
                }
                case 6: {
                    delta = 5;
                    break;
                }
                case 7: {
                    delta = 6;
                    break;
                }
                default: {
                    throw new Error("Unexpected Error. First day of month is non of Sun, Mon, Tue, Wed, Thu, Fri, Sat");
                }
            }
            this.dayName = new String[7];
            for (int i = 0; i < 7; ++i) {
                this.dayName[i] = shortWeekdays[(i + delta) % 7 + 1];
            }
        }
        return this.dayName;
    }

    protected boolean isWeekend(int dayOfMonth) {
        Calendar temp = (Calendar)this.month.clone();
        temp.set(5, dayOfMonth);
        int dayName = temp.get(7);
        return dayName == 7 || dayName == 1;
    }

    public void rebuildGui() {
        this.initGui();
        this.refresh();
    }

    protected int[][] getDatesForButtons(Calendar month) {
        int[][] result = new int[6][7];
        this.tempDate.setTime(month.getTime().getTime());
        if (this.tempCal == null) {
            this.tempCal = (Calendar)month.clone();
        }
        this.tempCal.setTime(this.tempDate);
        Calendar day = this.tempCal;
        day.set(5, 1);
        int x = 0;
        while (day.get(7) != day.getFirstDayOfWeek()) {
            day.roll(7, false);
            ++x;
        }
        day = (Calendar)month.clone();
        day.set(5, 1);
        for (int y = 0; y < 6; ++y) {
            while (x < 7) {
                result[y][x] = day.get(5);
                day.roll(5, true);
                if (day.get(5) == 1) {
                    return result;
                }
                ++x;
            }
            x = 0;
        }
        throw new Error("Unexpected Error. Month has more than 31 days!");
    }

    protected String formatDate(Date date) {
        return this.format.format(date);
    }

    public synchronized void removeActionListener(ActionListener l) {
        if (this.actionListeners != null && this.actionListeners.contains(l)) {
            Vector v = (Vector)this.actionListeners.clone();
            v.removeElement(l);
            this.actionListeners = v;
        }
    }

    public synchronized void addActionListener(ActionListener l) {
        Vector v;
        Vector vector = v = this.actionListeners == null ? new Vector(2) : (Vector)this.actionListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.actionListeners = v;
        }
    }

    protected void fireActionPerformed(ActionEvent e) {
        if (this.actionListeners != null) {
            Vector<ActionListener> listeners = this.actionListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                listeners.elementAt(i).actionPerformed(e);
            }
        }
    }

    private class MyActionListener
    implements ActionListener,
    Serializable {
        private MyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            MonthPanel.this.fireActionPerformed(new ActionEvent(MonthPanel.this, 1001, null));
        }
    }

    private class MyItemListener
    implements ItemListener,
    Serializable {
        private MyItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (MonthPanel.this.pendingShowMonth) {
                return;
            }
            if (e.getStateChange() == 1) {
                String day = ((JToggleButton)e.getSource()).getText();
                try {
                    int d = Integer.parseInt(day);
                    MonthPanel.this.setSelectedDay(d);
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                MonthPanel.this.setSelectedDate(null, false);
            }
        }
    }

    public static class Configuration
    extends MonthPanelUISettings {
        public Configuration() {
            this.updateUI();
        }

        public void updateUI() {
            this.setDelegate(new MonthPanelUISettingsDefaults());
        }
    }
}

