/*
 * Decompiled with CFR 0.152.
 */
package org.beanfabrics.swing.goodies.calendar;

import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import org.beanfabrics.swing.goodies.calendar.MonthPanelUISettings;

public class MonthPanelUISettingsDefaults
extends MonthPanelUISettings {
    private Font baseFont;
    private Color selectionForeground;
    private Color selectionBackground;
    private Color dayBackground;

    public MonthPanelUISettingsDefaults() {
        UIDefaults def = UIManager.getLookAndFeelDefaults();
        if (this.isNimbus()) {
            this.baseFont = def.getFont("Label.font");
            this.selectionForeground = MonthPanelUISettingsDefaults.copy(def.getColor("nimbusSelectedText"));
            this.selectionBackground = MonthPanelUISettingsDefaults.copy(def.getColor("nimbusSelectionBackground"));
            this.dayBackground = MonthPanelUISettingsDefaults.copy(def.getColor("nimbusLightBackground"));
        } else {
            this.baseFont = def.getFont("Label.font");
            this.selectionForeground = MonthPanelUISettingsDefaults.copy(def.getColor("List.selectionForeground"));
            this.selectionBackground = MonthPanelUISettingsDefaults.copy(def.getColor("List.selectionBackground"));
            this.dayBackground = MonthPanelUISettingsDefaults.copy(def.getColor("List.background"));
        }
        if (this.isMotif()) {
            this.setWeekendForegroundColor(new Color(119, 66, 8));
            this.setTodayForegroundColor(new Color(204, 51, 51));
        } else {
            this.setWeekendForegroundColor(new Color(238, 129, 0));
            this.setTodayForegroundColor(Color.RED);
        }
        this.setWorkdayForegroundColor(new Color(21, 55, 93));
        this.setSelectedColor(this.selectionForeground);
        this.setSelectedBackgroundColor(this.selectionBackground);
        this.setBackgroundColor(this.dayBackground);
        this.setHeaderFont(this.baseFont.deriveFont(0));
        this.setHeaderForegroundColor(Color.BLACK);
        this.setDayFont(this.baseFont.deriveFont(0).deriveFont(this.baseFont.getSize2D() * 0.8f));
        this.setDateFont(this.baseFont);
        this.setDayMargin(new Insets(1, 1, 1, 1));
    }

    private static Color copy(Color color) {
        return new Color(color.getRGB());
    }

    private boolean isNimbus() {
        return "Nimbus".equals(UIManager.getLookAndFeel().getID());
    }

    private boolean isMotif() {
        return "Motif".equals(UIManager.getLookAndFeel().getID());
    }
}

