/*
 * Decompiled with CFR 0.152.
 */
package org.beanfabrics.swing.customizer.list;

import org.beanfabrics.Path;
import org.beanfabrics.model.PMManager;
import org.beanfabrics.model.PresentationModel;
import org.beanfabrics.support.OnChange;
import org.beanfabrics.swing.customizer.AbstractCustomizerPM;
import org.beanfabrics.swing.customizer.CustomizerBase;
import org.beanfabrics.swing.customizer.path.PathContext;
import org.beanfabrics.swing.customizer.path.PathPM;
import org.beanfabrics.swing.customizer.util.CustomizerUtil;
import org.beanfabrics.swing.list.BnList;
import org.beanfabrics.swing.list.CellConfig;

public class BnListCustomizerPM
extends AbstractCustomizerPM {
    private CustomizerBase customizer;
    private BnList bnList;
    protected final PathPM pathToList = new PathPM();
    protected final PathPM cellConfigPath = new PathPM();

    public BnListCustomizerPM() {
        PMManager.setup((PresentationModel)this);
    }

    @Override
    public void setCustomizer(CustomizerBase customizer) {
        this.customizer = customizer;
        this.setBnList((BnList)customizer.getObject());
    }

    public void setBnList(BnList bnList) {
        this.bnList = bnList;
        this.pathToList.setData(bnList.getPath());
        this.pathToList.setPathContext(CustomizerUtil.getPathContextToCustomizeModelSubscriber(bnList));
        this.revalidateProperties();
        this.configureCellConfigPath();
    }

    @OnChange(path={"pathToList"})
    void applyPathToList() {
        if (this.pathToList.isValid() && this.bnList != null && this.customizer != null) {
            Path oldValue = this.bnList.getPath();
            Path newValue = this.pathToList.getData();
            this.bnList.setPath(newValue);
            this.customizer.firePropertyChange("path", oldValue, newValue);
        }
        this.configureCellConfigPath();
    }

    @OnChange(path={"cellConfigPath"})
    void applyPathToRowPm() {
        if (this.cellConfigPath.isValid() && this.bnList != null && this.customizer != null) {
            CellConfig oldValue = this.bnList.getCellConfig();
            CellConfig newValue = !this.cellConfigPath.isEmpty() ? new CellConfig(this.cellConfigPath.getData()) : null;
            this.bnList.setCellConfig(newValue);
            this.customizer.firePropertyChange("cellConfig", oldValue, newValue);
        }
    }

    private void configureCellConfigPath() {
        if (this.bnList != null) {
            Path initialPath = this.getCellConfigPath(this.bnList.getCellConfig());
            this.cellConfigPath.setData(initialPath);
            this.cellConfigPath.setPathContext(new PathContext(CustomizerUtil.asRootNode(CustomizerUtil.getElementTypeOfSubscribedOrActualIListPM(this.bnList)), null));
        } else {
            this.cellConfigPath.setData(null);
        }
    }

    private Path getCellConfigPath(CellConfig cellConfig) {
        if (cellConfig == null) {
            return null;
        }
        return cellConfig.getPath();
    }
}

