/*
 * Decompiled with CFR 0.152.
 */
package org.beanfabrics.swing.customizer.table;

import org.beanfabrics.swing.customizer.table.ObjectToSourceCodeFormatter;
import org.beanfabrics.swing.table.BnColumn;
import org.beanfabrics.swing.table.BnColumnBuilder;

public class BnColumnBuilderJavaFormat
implements ObjectToSourceCodeFormatter<BnColumn[]> {
    private static final String BUILDER_CLASSNAME = BnColumnBuilder.class.getName();
    private String builderClassname;
    private String columnDelimiter = "\n\t      ";

    public BnColumnBuilderJavaFormat() {
        this(BUILDER_CLASSNAME);
    }

    protected BnColumnBuilderJavaFormat(String builderClassname) {
        this.builderClassname = builderClassname;
    }

    public String getColumnDelimiter() {
        return this.columnDelimiter;
    }

    public void setColumnDelimiter(String columnDelimiter) {
        this.columnDelimiter = columnDelimiter;
    }

    @Override
    public String format(BnColumn[] columns) {
        StringBuilder sb = new StringBuilder();
        if (columns == null || columns.length == 0) {
            return null;
        }
        sb.append("new " + this.builderClassname + "()");
        for (int i = 0; i < columns.length; ++i) {
            BnColumn c = columns[i];
            sb.append(this.columnDelimiter);
            if (c == null) continue;
            sb.append(".addColumn()");
            this.appendProperties(sb, c);
        }
        sb.append(this.columnDelimiter);
        sb.append(".build()");
        return sb.toString();
    }

    protected void appendProperties(StringBuilder sb, BnColumn column) {
        if (column.getPath() != null) {
            sb.append(".withPath(\"" + column.getPath().getPathString() + "\")");
        }
        if (column.getColumnName() != null) {
            sb.append(".withName(\"" + column.getColumnName() + "\")");
        }
        if (column.getWidth() != 100) {
            sb.append(".withWidth(" + column.getWidth() + ")");
        }
        if (column.isWidthFixed()) {
            sb.append(".withWidthFixed(" + column.isWidthFixed() + ")");
        }
        if (column.getOperationPath() != null) {
            sb.append(".withOperationPath(\"" + column.getOperationPath().getPathString() + "\")");
        }
        if (!BnColumnBuilderJavaFormat.equals(column.getAlignment(), BnColumn.DEFAULT_ALIGNEMNT)) {
            sb.append(".withAlignment(" + this.getAlignmentConstantString(column.getAlignment()) + ")");
        }
    }

    private static boolean equals(Integer a, Integer b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }

    private String getAlignmentConstantString(Integer alignment) {
        String code;
        if (alignment == null) {
            return "null";
        }
        switch (alignment) {
            case 10: {
                code = this.builderClassname + ".ALIGNMENT_LEADING";
                break;
            }
            case 2: {
                code = this.builderClassname + ".ALIGNMENT_LEFT";
                break;
            }
            case 11: {
                code = this.builderClassname + ".ALIGNMENT_TRAILING";
                break;
            }
            case 4: {
                code = this.builderClassname + ".ALIGNMENT_RIGHT";
                break;
            }
            case 0: {
                code = this.builderClassname + ".ALIGNMENT_CENTER";
                break;
            }
            default: {
                code = "null";
            }
        }
        return code;
    }
}

